/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.datasource.AbstractDataSourceManager;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.core.datasource.DataSourceConsumerExtensionPoint;
import org.ametys.core.datasource.LDAPDataSourceManager;
import org.ametys.core.datasource.SQLDataSourceManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.I18nUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.checker.ItemCheckerTestFailureException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class DataSourceClientInteraction
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = DataSourceClientInteraction.class.getName();
    private SQLDataSourceManager _sqlDataSourceManager;
    private LDAPDataSourceManager _ldapDataSourceManager;
    private DataSourceConsumerExtensionPoint _dataSourceConsumerEP;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._sqlDataSourceManager = (SQLDataSourceManager)serviceManager.lookup(SQLDataSourceManager.ROLE);
        this._ldapDataSourceManager = (LDAPDataSourceManager)serviceManager.lookup(LDAPDataSourceManager.ROLE);
        this._dataSourceConsumerEP = (DataSourceConsumerExtensionPoint)serviceManager.lookup(DataSourceConsumerExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)serviceManager.lookup(I18nUtils.ROLE));
    }

    public List<Map<String, Object>> getDataSources(DataSourceType dataSourceType, boolean includePrivate, boolean includeInternal, boolean includeDefault, List<String> allowedTypes) throws Exception {
        ArrayList<Map<String, Object>> datasources = new ArrayList<Map<String, Object>>();
        switch (dataSourceType.ordinal()) {
            case 0: {
                Map<String, AbstractDataSourceManager.DataSourceDefinition> sqlDataSources = this._sqlDataSourceManager.getDataSourceDefinitions(includePrivate, includeInternal, includeDefault);
                for (String id : sqlDataSources.keySet()) {
                    if (allowedTypes != null && !allowedTypes.contains(sqlDataSources.get(id).getParameters().get("dbtype"))) continue;
                    datasources.add(this.getSQLDataSource(id));
                }
                break;
            }
            case 1: {
                Map<String, AbstractDataSourceManager.DataSourceDefinition> ldapDataSources = this._ldapDataSourceManager.getDataSourceDefinitions(includePrivate, includeInternal, includeDefault);
                for (String id : ldapDataSources.keySet()) {
                    datasources.add(this.getLDAPDataSource(id));
                }
                break;
            }
        }
        return datasources;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getDataSources(String dataSourceType, boolean includePrivate, boolean includeInternal, boolean includeDefault, List<String> allowedTypes) throws Exception {
        ArrayList<Map<String, Object>> datasources = new ArrayList<Map<String, Object>>();
        if (StringUtils.isEmpty((CharSequence)dataSourceType) || dataSourceType.equals(DataSourceType.SQL.toString())) {
            datasources.addAll(this.getDataSources(DataSourceType.SQL, includePrivate, includeInternal, includeDefault, allowedTypes));
        }
        if (StringUtils.isEmpty((CharSequence)dataSourceType) || dataSourceType.equals(DataSourceType.LDAP.toString())) {
            datasources.addAll(this.getDataSources(DataSourceType.LDAP, includePrivate, includeInternal, includeDefault, allowedTypes));
        }
        return datasources;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public List<Map<String, Object>> getDataSources(boolean includePrivate, boolean includeInternal, boolean includeDefault) throws Exception {
        return this.getDataSources((String)null, includePrivate, includeInternal, includeDefault, null);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getDataSource(String type, String id) throws Exception {
        DataSourceType dsType = DataSourceType.valueOf(type);
        switch (dsType.ordinal()) {
            case 0: {
                return this.getSQLDataSource(id);
            }
            case 1: {
                return this.getLDAPDataSource(id);
            }
        }
        this.getLogger().error("Unable to get data source: unknown data source type '" + type + "'.");
        return null;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getLDAPDataSource(String id) throws Exception {
        AbstractDataSourceManager.DataSourceDefinition ldapDefinition = this._ldapDataSourceManager.getDataSourceDefinition(id);
        Map<String, Object> def2json = this._dataSourceDefinition2Json(DataSourceType.LDAP.toString(), ldapDefinition);
        if (ldapDefinition == null) {
            this.getLogger().error("Unable to find the data source definition for the id '" + id + "'.");
        } else {
            def2json.put("id", id);
            def2json.put("type", "LDAP");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.putAll(ldapDefinition.getParameters());
            if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("adminPassword")))) {
                parameters.put("adminPassword", "PASSWORD");
            }
            def2json.putAll(parameters);
            boolean isInUse = DataSourceConsumer.TypeOfUse.merge(this._dataSourceConsumerEP.isInUse(ldapDefinition.getId()), ldapDefinition.isDefault() ? this._dataSourceConsumerEP.isInUse(this._ldapDataSourceManager.getDefaultDataSourceId()) : DataSourceConsumer.TypeOfUse.NOT_USED) != DataSourceConsumer.TypeOfUse.NOT_USED;
            def2json.put("isInUse", isInUse);
            if ((this._ldapDataSourceManager.getDataSourcePrefixId() + "default-datasource").equals(id)) {
                this._setDefaultDataSourceName(def2json);
            }
        }
        return def2json;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getSQLDataSource(String id) throws Exception {
        AbstractDataSourceManager.DataSourceDefinition sqlDefinition = this._sqlDataSourceManager.getDataSourceDefinition(id);
        Map<String, Object> def2json = this._dataSourceDefinition2Json(DataSourceType.SQL.toString(), sqlDefinition);
        if (sqlDefinition == null) {
            this.getLogger().error("Unable to find the data source definition for the id '" + id + "'.");
        } else {
            def2json.put("id", id);
            def2json.put("type", "SQL");
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.putAll(sqlDefinition.getParameters());
            if (StringUtils.isNotBlank((CharSequence)((String)parameters.get("password")))) {
                parameters.put("password", "PASSWORD");
            }
            def2json.putAll(parameters);
            boolean isInUse = DataSourceConsumer.TypeOfUse.merge(this._dataSourceConsumerEP.isInUse(sqlDefinition.getId()), sqlDefinition.isDefault() ? this._dataSourceConsumerEP.isInUse(this._sqlDataSourceManager.getDefaultDataSourceId()) : DataSourceConsumer.TypeOfUse.NOT_USED) != DataSourceConsumer.TypeOfUse.NOT_USED;
            def2json.put("isInUse", isInUse);
            if (this._sqlDataSourceManager.getDefaultDataSourceId().equals(id)) {
                this._setDefaultDataSourceName(def2json);
            }
        }
        return def2json;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> addDataSource(String type, Map<String, Object> parameters) throws ProcessingException, ConfigurationException, SAXException, IOException {
        String name = (String)parameters.get("name");
        String description = (String)parameters.get("description");
        boolean isPrivate = (Boolean)parameters.get("private");
        parameters.remove("id");
        parameters.remove("name");
        parameters.remove("description");
        parameters.remove("private");
        parameters.remove("type");
        AbstractDataSourceManager.DataSourceDefinition def = null;
        if (type.equals(DataSourceType.SQL.toString())) {
            def = this._sqlDataSourceManager.add(new I18nizableText(name), new I18nizableText(description), parameters, isPrivate);
        } else if (type.equals(DataSourceType.LDAP.toString())) {
            def = this._ldapDataSourceManager.add(new I18nizableText(name), new I18nizableText(description), parameters, isPrivate);
        } else {
            throw new IllegalArgumentException("Unable to add data source: unknown data source type '" + type + "'.");
        }
        return this._dataSourceDefinition2Json(type, def);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> editDataSource(String type, Map<String, Object> parameters) throws ProcessingException, ConfigurationException, SAXException, IOException {
        String id = (String)parameters.get("id");
        String name = (String)parameters.get("name");
        String description = (String)parameters.get("description");
        boolean isPrivate = (Boolean)parameters.get("private");
        parameters.remove("id");
        parameters.remove("name");
        parameters.remove("description");
        parameters.remove("private");
        parameters.remove("type");
        AbstractDataSourceManager.DataSourceDefinition def = null;
        if (type.equals(DataSourceType.SQL.toString())) {
            AbstractDataSourceManager.DataSourceDefinition previousdataSourceDefinition = this._sqlDataSourceManager.getDataSourceDefinition(id);
            if (previousdataSourceDefinition != null) {
                String previousPassword = (String)previousdataSourceDefinition.getParameters().get("password");
                if (parameters.get("password") == null && StringUtils.isNotEmpty((CharSequence)previousPassword)) {
                    parameters.put("password", previousPassword);
                }
            } else {
                this.getLogger().error("The data source of id '" + id + "' was not found. Unable to get the previous password.");
            }
            def = this._sqlDataSourceManager.edit(id, new I18nizableText(name), new I18nizableText(description), parameters, isPrivate);
        } else if (type.equals(DataSourceType.LDAP.toString())) {
            AbstractDataSourceManager.DataSourceDefinition previousdataSourceDefinition = this._ldapDataSourceManager.getDataSourceDefinition(id);
            if (previousdataSourceDefinition != null) {
                String previousPassword = (String)previousdataSourceDefinition.getParameters().get("adminPassword");
                if (parameters.get("adminPassword") == null && StringUtils.isNotEmpty((CharSequence)previousPassword)) {
                    parameters.put("adminPassword", previousPassword);
                }
            } else {
                this.getLogger().error("The data source of id '" + id + "' was not found. Unable to get the previous password.");
            }
            def = this._ldapDataSourceManager.edit(id, new I18nizableText(name), new I18nizableText(description), parameters, isPrivate);
        } else {
            throw new IllegalArgumentException("Unable to edit data source: unknown data source type '" + type + "'.");
        }
        return this._dataSourceDefinition2Json(type, def);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public void removeDataSource(String type, List<String> ids) throws ConfigurationException, SAXException, IOException, ProcessingException {
        if (type.equals(DataSourceType.SQL.toString())) {
            this._sqlDataSourceManager.delete(ids, false);
        } else if (type.equals(DataSourceType.LDAP.toString())) {
            this._ldapDataSourceManager.delete(ids, false);
        } else {
            throw new IllegalArgumentException("Unable to delete data sources: unknown data source type '" + type + "'.");
        }
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> setDefaultDataSource(String type, String id) {
        AbstractDataSourceManager.DataSourceDefinition def = null;
        if (type.equals(DataSourceType.SQL.toString())) {
            def = this._sqlDataSourceManager.setDefaultDataSource(id);
        } else if (type.equals(DataSourceType.LDAP.toString())) {
            def = this._ldapDataSourceManager.setDefaultDataSource(id);
        } else {
            throw new IllegalArgumentException("Unable set to default the data source: unknown data source type '" + type + "'.");
        }
        return this._dataSourceDefinition2Json(type, def);
    }

    private void _setDefaultDataSourceName(Map<String, Object> dataSourceAsJSON) {
        Object defaultDataSourceName = this._i18nUtils.translate(new I18nizableText("plugin.core", "PLUGINS_CORE_DEFAULT_DATASOURCE_NAME_PREFIX"));
        defaultDataSourceName = (String)defaultDataSourceName + this._i18nUtils.translate((I18nizableText)dataSourceAsJSON.get("name"));
        defaultDataSourceName = (String)defaultDataSourceName + this._i18nUtils.translate(new I18nizableText("plugin.core", "PLUGINS_CORE_DEFAULT_DATASOURCE_NAME_SUFFIX"));
        dataSourceAsJSON.put("name", defaultDataSourceName);
    }

    private Map<String, Object> _dataSourceDefinition2Json(String type, AbstractDataSourceManager.DataSourceDefinition dataSourceDef) {
        HashMap<String, Object> infos = new HashMap<String, Object>();
        if (dataSourceDef != null) {
            infos.put("id", dataSourceDef.getId());
            infos.put("name", dataSourceDef.getName());
            infos.put("description", dataSourceDef.getDescription());
            infos.put("private", dataSourceDef.isPrivate());
            infos.put("isDefault", dataSourceDef.isDefault());
            boolean isInUse = DataSourceConsumer.TypeOfUse.merge(this._dataSourceConsumerEP.isInUse(dataSourceDef.getId()), dataSourceDef.isDefault() ? this._dataSourceConsumerEP.isInUse(this._ldapDataSourceManager.getDefaultDataSourceId()) : DataSourceConsumer.TypeOfUse.NOT_USED) != DataSourceConsumer.TypeOfUse.NOT_USED;
            infos.put("isInUse", isInUse);
            Map<String, Object> parameters = dataSourceDef.getParameters();
            for (String paramName : parameters.keySet()) {
                infos.put(paramName, parameters.get(paramName));
            }
            infos.put("isValid", this._isValid(type, parameters));
        }
        return infos;
    }

    private boolean _isValid(String type, Map<String, Object> parameters) {
        boolean isValid = true;
        if (type.equals(DataSourceType.SQL.toString())) {
            try {
                this._sqlDataSourceManager.checkParameters(parameters);
            }
            catch (ItemCheckerTestFailureException e) {
                isValid = false;
            }
        } else if (type.equals(DataSourceType.LDAP.toString())) {
            try {
                this._ldapDataSourceManager.checkParameters(parameters);
            }
            catch (ItemCheckerTestFailureException e) {
                isValid = false;
            }
        } else {
            throw new IllegalArgumentException("Unable to convert a data source definition to JSON : unknown data source type '" + type + "'.");
        }
        return isValid;
    }

    public static enum DataSourceType {
        SQL,
        LDAP;

    }
}

