/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Stream;

public interface DataSourceConsumer {
    public TypeOfUse isInUse(String var1);

    public Map<String, TypeOfUse> getUsedDataSourceIds();

    public static enum TypeOfUse {
        BLOCKING,
        NON_BLOCKING,
        NOT_USED;


        public static TypeOfUse merge(Collection<TypeOfUse> typesOfUse) {
            return TypeOfUse._merge(typesOfUse.stream());
        }

        public static TypeOfUse merge(TypeOfUse ... typesOfUse) {
            return TypeOfUse._merge(Arrays.stream(typesOfUse));
        }

        private static TypeOfUse _merge(Stream<TypeOfUse> typesOfUse) {
            return typesOfUse.filter(r -> r != null).min(Comparator.naturalOrder()).orElse(NOT_USED);
        }
    }
}

