/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ametys.core.datasource.DataSourceConsumer;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;

public class DataSourceConsumerExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<DataSourceConsumer> {
    public static final String ROLE = DataSourceConsumerExtensionPoint.class.getName();

    public DataSourceConsumer.TypeOfUse isInUse(String id) {
        HashSet<DataSourceConsumer.TypeOfUse> typesOfUse = new HashSet<DataSourceConsumer.TypeOfUse>();
        for (String extensionId : this.getExtensionsIds()) {
            DataSourceConsumer dataSourceClient = (DataSourceConsumer)this.getExtension(extensionId);
            typesOfUse.add(dataSourceClient.isInUse(id));
        }
        return DataSourceConsumer.TypeOfUse.merge(typesOfUse);
    }

    public Map<String, DataSourceConsumer.TypeOfUse> getUsedDataSourceIds() {
        Set<String> extensionsIds = this.getExtensionsIds();
        HashMap<String, DataSourceConsumer.TypeOfUse> usedDataSourceIds = new HashMap<String, DataSourceConsumer.TypeOfUse>();
        for (String extensionId : extensionsIds) {
            DataSourceConsumer dataSourceClient = (DataSourceConsumer)this.getExtension(extensionId);
            for (Map.Entry<String, DataSourceConsumer.TypeOfUse> usedDataSource : dataSourceClient.getUsedDataSourceIds().entrySet()) {
                if (usedDataSourceIds.containsKey(usedDataSource.getKey())) {
                    usedDataSourceIds.put(usedDataSource.getKey(), DataSourceConsumer.TypeOfUse.merge((DataSourceConsumer.TypeOfUse)((Object)usedDataSourceIds.get(usedDataSource.getKey())), usedDataSource.getValue()));
                    continue;
                }
                usedDataSourceIds.put(usedDataSource.getKey(), usedDataSource.getValue());
            }
        }
        return usedDataSourceIds;
    }
}

