/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.ametys.core.util.DateUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class ZonedDateTimeTypeHandler
extends BaseTypeHandler<ZonedDateTime> {
    public void setNonNullParameter(PreparedStatement ps, int i, ZonedDateTime parameter, JdbcType jdbcType) throws SQLException {
        ps.setTimestamp(i, Timestamp.from(parameter.toInstant()));
    }

    public ZonedDateTime getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnName);
        return this._getZonedDateTime(timestamp);
    }

    public ZonedDateTime getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp timestamp = rs.getTimestamp(columnIndex);
        return this._getZonedDateTime(timestamp);
    }

    public ZonedDateTime getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Timestamp timestamp = cs.getTimestamp(columnIndex);
        return this._getZonedDateTime(timestamp);
    }

    private ZonedDateTime _getZonedDateTime(Timestamp timestamp) {
        if (timestamp != null) {
            return DateUtils.asZonedDateTime(timestamp.toInstant(), ZoneId.systemDefault());
        }
        return null;
    }
}

