/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.datasource.dbtype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.core.datasource.dbtype.SQLDatabaseTypeExtensionPoint;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.I18nUtils;
import org.ametys.plugins.core.impl.datasource.StaticSQLDatabaseType;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class SQLDatabaseTypeManager
implements Component,
Serviceable {
    public static final String ROLE = SQLDatabaseTypeManager.class.getName();
    private SQLDatabaseTypeExtensionPoint _sqlDatabaseTypeExtensionPoint;
    private I18nUtils _i18nUtils;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._sqlDatabaseTypeExtensionPoint = (SQLDatabaseTypeExtensionPoint)serviceManager.lookup(SQLDatabaseTypeExtensionPoint.ROLE);
        this._i18nUtils = (I18nUtils)((Object)serviceManager.lookup(I18nUtils.ROLE));
    }

    @Callable(rights={"*"})
    public Map<String, Object> getSQLDatabaseTypes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList databaseTypes = new ArrayList();
        Map<String, I18nizableText> sqlDatabaseTypes = this._sqlDatabaseTypeExtensionPoint.getSQLDatabaseTypes();
        for (String extensionId : sqlDatabaseTypes.keySet()) {
            HashMap<String, String> databaseType = new HashMap<String, String>();
            StaticSQLDatabaseType staticSQLDatabaseType = (StaticSQLDatabaseType)this._sqlDatabaseTypeExtensionPoint.getExtension(extensionId);
            databaseType.put("label", this._i18nUtils.translate(staticSQLDatabaseType.getLabel()));
            databaseType.put("value", extensionId);
            databaseType.put("template", staticSQLDatabaseType.getTemplate());
            databaseTypes.add(databaseType);
        }
        result.put("databaseTypes", databaseTypes);
        return result;
    }

    public I18nizableText getClassNotFoundMessage(String driver) {
        Map<String, I18nizableText> sqlDatabaseTypes = this._sqlDatabaseTypeExtensionPoint.getSQLDatabaseTypes();
        for (String extensionId : sqlDatabaseTypes.keySet()) {
            StaticSQLDatabaseType staticSQLDatabaseType = (StaticSQLDatabaseType)this._sqlDatabaseTypeExtensionPoint.getExtension(extensionId);
            if (!staticSQLDatabaseType.getDriver().equals(driver)) continue;
            return staticSQLDatabaseType.getDriverNotFoundMessage();
        }
        return null;
    }
}

