/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.engine;

import java.util.HashMap;
import java.util.Map;
import org.ametys.core.engine.BackgroundEngineHook;
import org.ametys.core.engine.BackgroundEngineHookExtensionPoint;
import org.ametys.core.engine.BackgroundEnvironment;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.Environment;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;

public final class BackgroundEngineHelper {
    private static RandomStringGenerator _randomStringGenerator = new RandomStringGenerator.Builder().withinRange(48, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).get();

    private BackgroundEngineHelper() {
    }

    public static boolean environmentExists() {
        return CocoonComponentManager.getCurrentEnvironment() != null;
    }

    public static Map<String, Object> createAndEnterEngineEnvironment(ServiceManager manager, Context context, Logger logger) {
        BackgroundEngineHookExtensionPoint backgroundEngineHookEP;
        Processor processor;
        BackgroundEnvironment environment;
        try {
            environment = new BackgroundEnvironment(logger, context);
            processor = (Processor)manager.lookup(Processor.ROLE);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error during environment's setup.", (Throwable)e);
        }
        String requestId = _randomStringGenerator.generate(8);
        environment.getObjectModel().put("clirequest-id", requestId);
        Object processingKey = CocoonComponentManager.startProcessing((Environment)environment);
        int environmentDepth = CocoonComponentManager.markEnvironment();
        CocoonComponentManager.enterEnvironment((Environment)environment, (ComponentManager)new WrapperComponentManager(manager), (Processor)processor);
        try {
            backgroundEngineHookEP = (BackgroundEngineHookExtensionPoint)manager.lookup(BackgroundEngineHookExtensionPoint.ROLE);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error during environment's setup.", (Throwable)e);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("manager", manager);
        result.put("logger", logger);
        result.put("environment", (Object)environment);
        result.put("processor", processor);
        result.put("processingKey", processingKey);
        result.put("environmentDepth", environmentDepth);
        result.put("hookEP", backgroundEngineHookEP);
        for (String hookId : backgroundEngineHookEP.getExtensionsIds()) {
            BackgroundEngineHook hook = (BackgroundEngineHook)backgroundEngineHookEP.getExtension(hookId);
            hook.onEnteringEnvironment(result);
        }
        return result;
    }

    public static void leaveEngineEnvironment(Map<String, Object> environmentInformation) {
        if (environmentInformation == null) {
            return;
        }
        BackgroundEnvironment environment = (BackgroundEnvironment)((Object)environmentInformation.get("environment"));
        Processor processor = (Processor)environmentInformation.get("processor");
        Object processingKey = environmentInformation.get("processingKey");
        int environmentDepth = (Integer)environmentInformation.get("environmentDepth");
        ServiceManager manager = (ServiceManager)environmentInformation.get("manager");
        Logger logger = (Logger)environmentInformation.get("logger");
        BackgroundEngineHookExtensionPoint backgroundEngineHookEP = (BackgroundEngineHookExtensionPoint)environmentInformation.get("hookEP");
        for (String hookId : backgroundEngineHookEP.getExtensionsIds()) {
            BackgroundEngineHook hook = (BackgroundEngineHook)backgroundEngineHookEP.getExtension(hookId);
            hook.onLeavingEnvironment(environmentInformation);
        }
        CocoonComponentManager.leaveEnvironment();
        CocoonComponentManager.endProcessing((Environment)environment, (Object)processingKey);
        try {
            CocoonComponentManager.checkEnvironment((int)environmentDepth, (Logger)logger);
        }
        catch (Exception e) {
            throw new CascadingRuntimeException("Error checking the environment", (Throwable)e);
        }
        manager.release((Object)backgroundEngineHookEP);
        manager.release((Object)processor);
    }
}

