/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.file;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ametys.core.file.TikaProvider;
import org.ametys.core.user.CurrentUserProvider;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.servlet.multipart.Part;
import org.apache.cocoon.servlet.multipart.PartOnDisk;
import org.apache.cocoon.servlet.multipart.RejectedPart;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.file.PathUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.ModifiableTraversableSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.source.TraversableSource;
import org.apache.excalibur.source.impl.FileSource;
import org.apache.tika.mime.MediaType;

public final class FileHelper
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = FileHelper.class.getName();
    protected CurrentUserProvider _currentUserProvider;
    protected TikaProvider _tikaProvider;
    private SourceResolver _srcResolver;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this._currentUserProvider = (CurrentUserProvider)serviceManager.lookup(CurrentUserProvider.ROLE);
        this._srcResolver = (SourceResolver)serviceManager.lookup(SourceResolver.ROLE);
        this._tikaProvider = (TikaProvider)((Object)serviceManager.lookup(TikaProvider.ROLE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> saveFile(String fileURI, String text) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        ModifiableTraversableSource src = null;
        try {
            src = (ModifiableTraversableSource)this._srcResolver.resolveURI(fileURI);
            if (!src.exists()) {
                result.put("success", false);
                result.put("error", "unknown-file");
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            if (src.isCollection()) {
                result.put("success", false);
                result.put("error", "is-not-file");
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            try (OutputStream os = src.getOutputStream();){
                IOUtils.write((String)text, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
            }
            if (src.getName().startsWith("messages") && src.getName().endsWith(".xml")) {
                result.put("isI18n", true);
            }
        }
        finally {
            this._srcResolver.release((Source)src);
        }
        result.put("success", true);
        return result;
    }

    public Map<String, Object> addFolder(String parentURI, String name, boolean renameIfExists) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FileSource parentDir = (FileSource)this._srcResolver.resolveURI(parentURI);
        if (!parentDir.isCollection()) {
            result.put("success", false);
            result.put("error", "is-not-folder");
            return result;
        }
        int index = 2;
        Object folderName = name;
        if (!renameIfExists && parentDir.getChild((String)folderName).exists()) {
            result.put("success", false);
            result.put("error", "already-exist");
            return result;
        }
        while (parentDir.getChild((String)folderName).exists()) {
            folderName = name + " (" + index + ")";
            ++index;
        }
        FileSource folder = (FileSource)parentDir.getChild((String)folderName);
        folder.makeCollection();
        result.put("success", true);
        result.put("name", folder.getName());
        result.put("uri", folder.getURI());
        return result;
    }

    public Map<String, Object> addOrUpdateFile(Part part, FileSource parentDir, String mode, boolean unzip) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (!(part instanceof PartOnDisk)) {
            RejectedPart rejectedPart;
            result.put("success", false);
            if (part instanceof RejectedPart && (rejectedPart = (RejectedPart)part).getMaxContentLength() == 0) {
                result.put("error", "infected");
            } else {
                result.put("error", "rejected");
            }
            return result;
        }
        PartOnDisk uploadedFilePart = (PartOnDisk)part;
        File uploadedFile = uploadedFilePart.getFile();
        Object fileName = uploadedFile.getName();
        FileSource file = (FileSource)parentDir.getChild((String)fileName);
        if (((String)fileName).toLowerCase().endsWith(".zip") && unzip) {
            try {
                ZipFile zipFile = ((ZipFile.Builder)((ZipFile.Builder)ZipFile.builder().setFile(uploadedFile)).setCharset("cp437")).get();
                this._unzip(parentDir, zipFile);
                result.put("unzip", true);
                result.put("success", true);
                return result;
            }
            catch (IOException e) {
                this.getLogger().error("Failed to unzip file " + uploadedFile.getPath(), (Throwable)e);
                result.put("success", false);
                result.put("error", "unzip-error");
                return result;
            }
        }
        if (file.exists()) {
            if ("add-rename".equals(mode)) {
                String[] f = ((String)fileName).split("\\.");
                int index = 1;
                while (parentDir.getChild((String)fileName).exists()) {
                    fileName = f[0] + "-" + index++ + "." + f[1];
                }
                file = (FileSource)parentDir.getChild((String)fileName);
            } else if (!"update".equals(mode)) {
                result.put("success", false);
                result.put("error", "already-exist");
                return result;
            }
        } else {
            file.getFile().createNewFile();
        }
        FileInputStream is = new FileInputStream(uploadedFile);
        SourceUtil.copy((InputStream)is, (OutputStream)file.getOutputStream());
        result.put("name", file.getName());
        result.put("uri", file.getURI());
        result.put("success", true);
        return result;
    }

    private void _unzip(FileSource destSrc, ZipFile zipFile) throws IOException {
        Enumeration entries = zipFile.getEntries();
        while (entries.hasMoreElements()) {
            FileSource parentCollection = destSrc;
            ZipArchiveEntry zipEntry = (ZipArchiveEntry)entries.nextElement();
            String zipName = zipEntry.getName();
            String[] path = zipName.split("/");
            for (int i = 0; i < path.length - 1; ++i) {
                String name = path[i];
                parentCollection = this._addCollection(parentCollection, name);
            }
            String name = path[path.length - 1];
            if (zipEntry.isDirectory()) {
                parentCollection = this._addCollection(parentCollection, name);
                continue;
            }
            this._addZipEntry(parentCollection, zipFile, zipEntry, name);
        }
    }

    private FileSource _addCollection(FileSource collection, String name) throws IOException {
        FileSource src = (FileSource)collection.getChild(name);
        if (!src.exists()) {
            src.makeCollection();
        }
        return src;
    }

    private void _addZipEntry(FileSource collection, ZipFile zipFile, ZipArchiveEntry zipEntry, String fileName) throws IOException {
        FileSource fileSrc = (FileSource)collection.getChild(fileName);
        try (InputStream is = zipFile.getInputStream(zipEntry);){
            SourceUtil.copy((InputStream)is, (OutputStream)fileSrc.getOutputStream());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Map<String, Object> deleteFile(String fileUri) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FileSource file = (FileSource)this._srcResolver.resolveURI(fileUri);
        if (file.exists()) {
            FileUtils.deleteQuietly((File)file.getFile());
            result.put("success", true);
        } else {
            result.put("success", false);
            result.put("error", "no-exists");
        }
        return result;
    }

    public void delete(Path path, DirectoryStream.Filter<Path> fileFilter, boolean recursiveDelete, boolean deleteEmptyDirs) throws IOException {
        if (Files.isDirectory(path, new LinkOption[0])) {
            if (recursiveDelete) {
                try (DirectoryStream<Path> entries = Files.newDirectoryStream(path);){
                    for (Path entry : entries) {
                        this.delete(entry, fileFilter, recursiveDelete, deleteEmptyDirs);
                    }
                }
            }
            if (deleteEmptyDirs && PathUtils.isEmptyDirectory((Path)path)) {
                Files.delete(path);
            }
        } else if (fileFilter.accept(path)) {
            Files.delete(path);
        }
    }

    public Map<String, Object> renameFile(String fileUri, String name) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FileSource file = (FileSource)this._srcResolver.resolveURI(fileUri);
        FileSource parentDir = (FileSource)file.getParent();
        if (file.getFile().getName().equals(name) && parentDir.getChild(name).exists()) {
            result.put("success", false);
            result.put("error", "already-exist");
        } else {
            Source dest = this._srcResolver.resolveURI(parentDir.getURI() + name);
            file.moveTo(dest);
            result.put("success", true);
            result.put("uri", parentDir.getURI() + name);
            result.put("name", name);
        }
        return result;
    }

    public boolean hasChild(String parentUri, String name) throws IOException {
        FileSource currentDir = (FileSource)this._srcResolver.resolveURI(parentUri);
        return currentDir.getChild(name).exists();
    }

    public Map<String, Object> copySource(String srcUri, String parentTargetUri) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FileSource srcFile = (FileSource)this._srcResolver.resolveURI(srcUri);
        if (!srcFile.exists()) {
            result.put("success", false);
            result.put("error", "no-exists");
            return result;
        }
        String srcFileName = srcFile.getName();
        FileSource targetFile = (FileSource)this._srcResolver.resolveURI(parentTargetUri + (String)(srcFileName.length() > 0 ? "/" + srcFileName : ""));
        int index = 2;
        Object fileName = srcFileName;
        while (targetFile.exists()) {
            fileName = srcFileName + " (" + index + ")";
            targetFile = (FileSource)this._srcResolver.resolveURI(parentTargetUri + (String)(((String)fileName).length() > 0 ? "/" + (String)fileName : ""));
            ++index;
        }
        if (srcFile.getFile().isDirectory()) {
            FileUtils.copyDirectory((File)srcFile.getFile(), (File)targetFile.getFile());
        } else {
            FileUtils.copyFile((File)srcFile.getFile(), (File)targetFile.getFile());
        }
        result.put("success", true);
        result.put("name", targetFile.getName());
        result.put("uri", targetFile.getURI());
        return result;
    }

    public Map<String, Object> moveSource(String srcUri, String parentTargetUri) throws IOException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FileSource srcFile = (FileSource)this._srcResolver.resolveURI(srcUri);
        if (!srcFile.exists()) {
            result.put("success", false);
            result.put("error", "no-exists");
            return result;
        }
        FileSource parentDargetDir = (FileSource)this._srcResolver.resolveURI(parentTargetUri);
        String fileName = srcFile.getName();
        FileSource targetFile = (FileSource)this._srcResolver.resolveURI(parentTargetUri + (String)(fileName.length() > 0 ? "/" + fileName : ""));
        if (targetFile.exists()) {
            result.put("msg", "already-exists");
            return result;
        }
        FileUtils.moveToDirectory((File)srcFile.getFile(), (File)parentDargetDir.getFile(), (boolean)false);
        result.put("success", true);
        result.put("name", targetFile.getName());
        result.put("uri", targetFile.getURI());
        return result;
    }

    public List<String> filterSources(TraversableSource source, String value) {
        return this._filterSources(source, this._standardizeValue(value));
    }

    private List<String> _filterSources(TraversableSource source, String value) {
        ArrayList<String> matches = new ArrayList<String>();
        if (source.isCollection()) {
            if (this._sourceNameMatch(source, value)) {
                matches.add(source.getURI());
            }
            try {
                Collection children = source.getChildren();
                for (TraversableSource child : children) {
                    matches.addAll(this._filterSources(child, value));
                }
            }
            catch (IOException e) {
                this.getLogger().error("Failed to retrieve children for source '" + source.getURI() + "'. Potential children will be ignored.");
            }
        } else if (this._resourceMatch(source, value)) {
            matches.add(source.getURI());
        }
        return matches;
    }

    private String _standardizeValue(String value) {
        return value.toLowerCase();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _resourceMatch(TraversableSource currentSrc, String value) {
        if (this._sourceNameMatch(currentSrc, value)) {
            return true;
        }
        MediaType mediaType = MediaType.parse((String)this._tikaProvider.getTika().detect(currentSrc.getName()));
        if (!this._isSupportedType(mediaType)) return false;
        try (InputStream is = currentSrc.getInputStream();){
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            do {
                if ((line = reader.readLine()) == null) return false;
            } while (!this._standardizeValue(line).contains(value));
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            this.getLogger().error("An error occurred while trying to read the definition file at '" + currentSrc.getURI() + "'", (Throwable)e);
        }
        return false;
    }

    private boolean _isSupportedType(MediaType mediaType) {
        String type = mediaType.getType();
        if (Strings.CS.equals(type, "text")) {
            return true;
        }
        if (Strings.CS.equals(type, "application")) {
            String subtype = mediaType.getSubtype();
            return Strings.CS.equals(subtype, "xml") || Strings.CS.contains((CharSequence)subtype, (CharSequence)"+xml") || Strings.CS.equals(subtype, "json") || Strings.CS.contains((CharSequence)subtype, (CharSequence)"+json");
        }
        return false;
    }

    private boolean _sourceNameMatch(TraversableSource currentSrc, String value) {
        return this._standardizeValue(currentSrc.getName()).contains(value);
    }
}

