/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ametys.core.AmetysContextHelper;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.right.RightManager;
import org.ametys.core.ui.Callable;
import org.ametys.core.user.CurrentUserProvider;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.PopulationContextHelper;
import org.ametys.runtime.authentication.AccessDeniedException;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class GroupDirectoryContextHelper
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = GroupDirectoryContextHelper.class.getName();
    public static final String ADMIN_CONTEXT = "/admin";
    private static final String __GROUP_DIRECTORIES_TABLE = "GroupDirectoriesByContext";
    private static final String __GROUP_DIRECTORIES_BY_CONTEXT_CACHE = "groupDirectoriesByContext";
    private static final String IS_CACHE_FILLED = "###iscachefilled###";
    private GroupDirectoryDAO _groupDirectoryDAO;
    private AbstractCacheManager _abstractCacheManager;
    private RightManager _rightManager;
    private PopulationContextHelper _populationContextHelper;
    private CurrentUserProvider _currentUserProvider;
    private AmetysContextHelper _ametysContextHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._abstractCacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._rightManager = (RightManager)manager.lookup(RightManager.ROLE);
        this._populationContextHelper = (PopulationContextHelper)manager.lookup(PopulationContextHelper.ROLE);
        this._currentUserProvider = (CurrentUserProvider)manager.lookup(CurrentUserProvider.ROLE);
        this._ametysContextHelper = (AmetysContextHelper)manager.lookup(AmetysContextHelper.ROLE);
    }

    public void initialize() throws Exception {
        this._abstractCacheManager.createMemoryCache(__GROUP_DIRECTORIES_BY_CONTEXT_CACHE, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_GROUP_DIRECTORY_CONTEXT_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_GROUP_DIRECTORY_CONTEXT_DESCRIPTION"), true, null);
    }

    protected Connection getSQLConnection() {
        String datasourceId = (String)Config.getInstance().getValue("runtime.assignments.groups");
        return ConnectionHelper.getConnection(datasourceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Set<String> link(String context, List<String> ids) {
        Set<String> result = this.getGroupDirectoriesOnContext(context);
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            connection = this.getSQLConnection();
            String sql = "DELETE FROM GroupDirectoriesByContext WHERE Context=?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, context);
            stmt.executeUpdate();
            this.getLogger().info("{}\n[{}]", (Object)sql, (Object)context);
            sql = "INSERT INTO GroupDirectoriesByContext (Context, GroupDirectory_Id) VALUES(?, ?)";
            stmt = connection.prepareStatement(sql);
            for (String id : ids) {
                if (this._groupDirectoryDAO.getGroupDirectory(id) != null) {
                    stmt.setString(1, context);
                    stmt.setString(2, id);
                    stmt.executeUpdate();
                    this.getLogger().info("{}\n[{}, {}]", new Object[]{sql, context, id});
                    if (result.contains(id)) {
                        result.remove(id);
                        continue;
                    }
                    result.add(id);
                    continue;
                }
                this.getLogger().warn("The GroupDirectory with id '{}' does not exist. It will not be linked.", (Object)id);
            }
        }
        catch (SQLException e) {
            try {
                this.getLogger().error("Error in sql query", (Throwable)e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                this._getCache().invalidateAll();
                throw throwable;
            }
            ConnectionHelper.cleanup(connection);
            ConnectionHelper.cleanup(stmt);
            this._getCache().invalidateAll();
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        this._getCache().invalidateAll();
        return result;
    }

    public Set<String> getContextsForGroupDirectory(String groupDirectoryId) {
        return this._getCacheAsMap().entrySet().stream().filter(entry -> ((Set)entry.getValue()).contains(groupDirectoryId)).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    public Set<String> getGroupDirectoriesOnContext(String context, boolean checkRights) throws AccessDeniedException {
        if (checkRights) {
            UserIdentity user = this._currentUserProvider.getUser();
            if (context.equals(ADMIN_CONTEXT)) {
                if (this._rightManager.currentUserHasRight("Runtime_Rights_Admin_Access", ADMIN_CONTEXT) != RightManager.RightResult.RIGHT_ALLOW) {
                    throw new AccessDeniedException("User " + String.valueOf(user) + " tried to access a set of group directories without convenient rights");
                }
            } else if (user == null || !this._ametysContextHelper.isRelatedWithContext(this._populationContextHelper.getContextsForUserPopulation(user.getPopulationId()), context)) {
                throw new AccessDeniedException("User " + String.valueOf(user) + " tried to access a set of group directory without convenient rights");
            }
        }
        return this.getGroupDirectoriesOnContext(context);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Set<String> getGroupDirectoriesOnContext(String context) {
        if (ADMIN_CONTEXT.equals(context)) {
            return this._groupDirectoryDAO.getGroupDirectoriesIds();
        }
        return this._getDirectoriesOnContextFromDatabase(context);
    }

    public Set<String> getGroupDirectoriesOnContexts(Set<String> contexts, boolean checkRights) throws AccessDeniedException {
        if (checkRights) {
            UserIdentity user = this._currentUserProvider.getUser();
            if (contexts.contains(ADMIN_CONTEXT) ? this._rightManager.currentUserHasRight("Runtime_Rights_Admin_Access", ADMIN_CONTEXT) != RightManager.RightResult.RIGHT_ALLOW : user == null || !this._ametysContextHelper.isRelatedWithAllContexts(this._populationContextHelper.getContextsForUserPopulation(user.getPopulationId()), contexts)) {
                throw new AccessDeniedException("User " + String.valueOf(user) + " tried to access a group directory without convenient rights");
            }
        }
        return this.getGroupDirectoriesOnContexts(contexts);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Set<String> getGroupDirectoriesOnContexts(Set<String> contexts) {
        return contexts.stream().map(this::getGroupDirectoriesOnContext).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> _getDirectoriesOnContextFromDatabase(String context) {
        return this._getCacheAsMap().computeIfAbsent(context, str -> new HashSet());
    }

    private synchronized Map<String, Set<String>> _getAllGroupDirectoryContent() {
        HashMap<String, Set<String>> cache = new HashMap<String, Set<String>>();
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = this.getSQLConnection();
            String sql = "SELECT Context, GroupDirectory_Id FROM GroupDirectoriesByContext";
            stmt = connection.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String context = rs.getString(1);
                String groupDirectoryId = rs.getString(2);
                if (this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId) == null) {
                    this.getLogger().warn("The group directory of id '{}' is linked to a context, but does not exist anymore.", (Object)groupDirectoryId);
                    continue;
                }
                Set cacheForContext = cache.computeIfAbsent(context, c -> new HashSet());
                cacheForContext.add(groupDirectoryId);
            }
        }
        catch (SQLException e) {
            try {
                throw new IllegalStateException("Cannot get group directories and contexts association because of an error in a sql query", e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(rs);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(connection);
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(rs);
        return cache;
    }

    protected synchronized Cache<String, Set<String>> _getCache() {
        Cache<String, Set<String>> cache = this._abstractCacheManager.get(__GROUP_DIRECTORIES_BY_CONTEXT_CACHE);
        if (!cache.hasKey(IS_CACHE_FILLED)) {
            Map<String, Set<String>> cacheMap = this._getAllGroupDirectoryContent();
            cache.putAll(cacheMap);
            cache.put(IS_CACHE_FILLED, null);
        }
        return cache;
    }

    protected synchronized Map<String, Set<String>> _getCacheAsMap() {
        Map<String, Set<String>> cacheAsMap = this._getCache().asMap();
        cacheAsMap.remove(IS_CACHE_FILLED);
        return cacheAsMap;
    }
}

