/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.group.directory.GroupDirectoryFactory;
import org.ametys.core.group.directory.GroupDirectoryModel;
import org.ametys.core.ui.Callable;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.ReadUsersAndGroupsDataHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.type.ModelItemType;
import org.ametys.runtime.model.type.xml.XMLElementType;
import org.ametys.runtime.plugin.PluginsManager;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GroupDirectoryDAO
extends AbstractLogEnabled
implements Component,
Initializable,
Serviceable,
Disposable {
    public static final String ROLE = GroupDirectoryDAO.class.getName();
    private static File __GROUP_DIRECTORIES_FILE;
    private static final String __ID_REGEX = "^[a-z][a-z0-9_-]*";
    private long _lastFileReading;
    private Map<String, GroupDirectory> _groupDirectories;
    private GroupDirectoryFactory _groupDirectoryFactory;
    private ReadUsersAndGroupsDataHelper _readXMLDataHelper;
    private I18nUtils _i18nUtils;

    public void initialize() {
        __GROUP_DIRECTORIES_FILE = new File(AmetysHomeHelper.getAmetysHome(), "config" + File.separator + "group-directories.xml");
        this._groupDirectories = new LinkedHashMap<String, GroupDirectory>();
        this._lastFileReading = 0L;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._groupDirectoryFactory = (GroupDirectoryFactory)manager.lookup(GroupDirectoryFactory.ROLE);
        this._readXMLDataHelper = (ReadUsersAndGroupsDataHelper)manager.lookup(ReadUsersAndGroupsDataHelper.ROLE);
        this._i18nUtils = (I18nUtils)((Object)manager.lookup(I18nUtils.ROLE));
    }

    public List<Object> getGroupDirectories2Json() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (GroupDirectory groupDirectory : this.getGroupDirectories()) {
            result.add(this.getGroupDirectory2Json(groupDirectory));
        }
        return result;
    }

    public Map<String, Object> getGroupDirectory2Json(GroupDirectory groupDirectory) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("id", groupDirectory.getId());
        result.put("label", groupDirectory.getLabel());
        String modelId = groupDirectory.getGroupDirectoryModelId();
        GroupDirectoryModel model = this._groupDirectoryFactory.getExtension(modelId);
        result.put("modelLabel", model.getLabel());
        return result;
    }

    public List<GroupDirectory> getGroupDirectories() {
        if (PluginsManager.Status.OK.equals((Object)PluginsManager.getInstance().getStatus())) {
            this._read(false);
            return new ArrayList<GroupDirectory>(this._groupDirectories.values());
        }
        return Collections.EMPTY_LIST;
    }

    public GroupDirectory getGroupDirectory(String id) {
        this._read(false);
        return this._groupDirectories.get(id);
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Set<String> getGroupDirectoriesIds() {
        this._read(false);
        return this._groupDirectories.keySet();
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getEditionConfiguration() throws Exception {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ArrayList groupDirectoryModels = new ArrayList();
        for (String extensionId : this._groupDirectoryFactory.getExtensionsIds()) {
            GroupDirectoryModel model = this._groupDirectoryFactory.getExtension(extensionId);
            LinkedHashMap<String, Object> gdMap = new LinkedHashMap<String, Object>();
            gdMap.put("id", extensionId);
            gdMap.put("label", model.getLabel());
            gdMap.put("description", model.getDescription());
            LinkedHashMap<CallSite, Map<String, Object>> params = new LinkedHashMap<CallSite, Map<String, Object>>();
            for (String paramId : model.getParameters().keySet()) {
                params.put((CallSite)((Object)(extensionId + "$" + paramId)), model.getParameters().get(paramId).toJSON(DefinitionContext.newInstance().withEdition(true)));
            }
            gdMap.put("parameters", params);
            groupDirectoryModels.add(gdMap);
        }
        result.put("groupDirectoryModels", groupDirectoryModels);
        return result;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> getGroupDirectoryParameterValues(String id) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this._read(false);
        GroupDirectory gd = this._groupDirectories.get(id);
        if (gd == null) {
            this.getLogger().error("The GroupDirectory of id '{}' does not exist.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        result.put("label", gd.getLabel());
        result.put("id", gd.getId());
        String modelId = gd.getGroupDirectoryModelId();
        result.put("modelId", modelId);
        HashMap<CallSite, Object> params = new HashMap<CallSite, Object>();
        for (String key : gd.getParameterValues().keySet()) {
            params.put((CallSite)((Object)(modelId + "$" + key)), gd.getParameterValues().get(key));
        }
        result.put("params", params);
        return result;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> add(String id, String label, String modelId, Map<String, String> params) {
        this._read(false);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (!this._isCorrectId(id)) {
            return null;
        }
        GroupDirectory gd = this._createGroupDirectory(id, label, modelId, params);
        if (gd == null) {
            this.getLogger().error("An error occured when creating the GroupDirectory with id '{}'. See previous logs for more information.", (Object)id);
            result.put("error", "server");
            return result;
        }
        this._groupDirectories.put(id, gd);
        if (this._write()) {
            this.getLogger().error("An error occured when writing the configuration file which contains the group directories.", (Object)id);
            result.put("error", "server");
            return result;
        }
        result.put("id", id);
        return result;
    }

    private boolean _isCorrectId(String id) {
        if (this._groupDirectories.get(id) != null) {
            this.getLogger().error("The id '{}' is already used for a group directory.", (Object)id);
            return false;
        }
        if (!Pattern.matches(__ID_REGEX, id)) {
            this.getLogger().error("The id '{}' is not a correct id for a group directory.", (Object)id);
            return false;
        }
        return true;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> edit(String id, String label, String modelId, Map<String, String> params) {
        this._read(false);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        GroupDirectory gd = this._groupDirectories.get(id);
        if (gd == null) {
            this.getLogger().error("The GroupDirectory with id '{}' does not exist, it cannot be edited.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        GroupDirectory removedGroupDirectory = this._groupDirectories.remove(id);
        LifecycleHelper.dispose((Object)removedGroupDirectory);
        GroupDirectory newGd = this._createGroupDirectory(id, label, modelId, params);
        if (newGd == null) {
            this.getLogger().error("An error occured when editing the GroupDirectory with id '{}'. See previous logs for more information.", (Object)id);
            result.put("error", "server");
            return result;
        }
        this._groupDirectories.put(id, newGd);
        if (this._write()) {
            this.getLogger().error("An error occured when writing the configuration file which contains the group directories.", (Object)id);
            result.put("error", "server");
            return result;
        }
        result.put("id", id);
        return result;
    }

    private GroupDirectory _createGroupDirectory(String id, String label, String modelId, Map<String, String> params) {
        Map<String, Object> typedParams = this._getTypedParams(params, modelId);
        return this._groupDirectoryFactory.createGroupDirectory(id, new I18nizableText(label), modelId, typedParams);
    }

    private Map<String, Object> _getTypedParams(Map<String, String> params, String modelId) {
        LinkedHashMap<String, Object> resultParameters = new LinkedHashMap<String, Object>();
        Map<String, ? extends ElementDefinition> declaredParameters = this._groupDirectoryFactory.getExtension(modelId).getParameters();
        for (String paramNameWithPrefix : params.keySet()) {
            String[] splitStr = paramNameWithPrefix.split("\\$", 2);
            String prefix = splitStr[0];
            String paramName = splitStr[1];
            if (prefix.equals(modelId) && declaredParameters.containsKey(paramName)) {
                String originalValue = params.get(paramNameWithPrefix);
                ElementDefinition parameter = declaredParameters.get(paramName);
                ModelItemType type = parameter.getType();
                Object typedValue = type.castValue(originalValue);
                resultParameters.put(paramName, typedValue);
                continue;
            }
            if (!prefix.equals(modelId)) continue;
            this.getLogger().warn("The parameter {} is not declared in extension {}. It will be ignored", (Object)paramName, (Object)modelId);
        }
        return resultParameters;
    }

    @Callable(rights={"Runtime_Rights_Admin_Access"}, context="/admin")
    public Map<String, Object> remove(String id) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this._read(false);
        GroupDirectory removedGroupDirectory = this._groupDirectories.remove(id);
        if (removedGroupDirectory == null) {
            this.getLogger().error("The GroupDirectory with id '{}' does not exist, it cannot be removed.", (Object)id);
            result.put("error", "unknown");
            return result;
        }
        LifecycleHelper.dispose((Object)removedGroupDirectory);
        if (this._write()) {
            return null;
        }
        result.put("id", id);
        return result;
    }

    private synchronized void _read(boolean forceRead) {
        block7: {
            try {
                if (!__GROUP_DIRECTORIES_FILE.exists()) {
                    this._createDirectoriesFile(__GROUP_DIRECTORIES_FILE);
                }
                long fileLastModified = __GROUP_DIRECTORIES_FILE.lastModified() / 1000L * 1000L;
                if (forceRead || fileLastModified >= this._lastFileReading) {
                    long lastFileReading = Instant.now().truncatedTo(ChronoUnit.SECONDS).toEpochMilli();
                    LinkedHashMap<String, GroupDirectory> groupDirectories = new LinkedHashMap<String, GroupDirectory>();
                    Configuration cfg = new DefaultConfigurationBuilder().buildFromFile(__GROUP_DIRECTORIES_FILE);
                    for (Configuration childCfg : cfg.getChildren("groupDirectory")) {
                        try {
                            GroupDirectory groupDirectory = this._configureGroupDirectory(childCfg);
                            if (groupDirectory == null) continue;
                            groupDirectories.put(groupDirectory.getId(), groupDirectory);
                        }
                        catch (ConfigurationException e) {
                            this.getLogger().error("Error configuring the group directory '" + childCfg.getAttribute("id", "") + "'. The group directory will be ignored.", (Throwable)e);
                        }
                    }
                    this.dispose();
                    this._lastFileReading = lastFileReading;
                    this._groupDirectories = groupDirectories;
                }
            }
            catch (IOException | TransformerConfigurationException | ConfigurationException | SAXException e) {
                if (!this.getLogger().isErrorEnabled()) break block7;
                this.getLogger().error("Error retrieving group directories with the configuration file " + String.valueOf(__GROUP_DIRECTORIES_FILE), e);
            }
        }
    }

    private void _createDirectoriesFile(File file) throws IOException, TransformerConfigurationException, SAXException {
        file.createNewFile();
        try (FileOutputStream os = new FileOutputStream(file);){
            TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
            StreamResult result = new StreamResult(os);
            th.setResult(result);
            Properties format = new Properties();
            format.put("method", "xml");
            format.put("indent", "yes");
            format.put("encoding", "UTF-8");
            format.put("{http://xml.apache.org/xalan}indent-amount", "4");
            th.getTransformer().setOutputProperties(format);
            th.startDocument();
            XMLUtils.createElement((ContentHandler)th, (String)"groupDirectories");
            th.endDocument();
        }
    }

    private GroupDirectory _configureGroupDirectory(Configuration configuration) throws ConfigurationException {
        GroupDirectory gd;
        String id = configuration.getAttribute("id");
        String modelId = configuration.getAttribute("modelId");
        I18nizableText label = new I18nizableText(configuration.getChild("label").getValue());
        Map<String, Object> paramValues = this._getParametersFromConfiguration(configuration.getChild("params"), modelId, id);
        if (paramValues != null && (gd = this._groupDirectoryFactory.createGroupDirectory(id, label, modelId, paramValues)) != null) {
            return gd;
        }
        return null;
    }

    private Map<String, Object> _getParametersFromConfiguration(Configuration conf, String modelId, String groupId) throws ConfigurationException {
        if (!this._groupDirectoryFactory.hasExtension(modelId)) {
            this.getLogger().warn("The model id '{}' is referenced in the file containing the group directories but seems to not exist.", (Object)modelId);
            return null;
        }
        Map<String, ? extends ElementDefinition> declaredParameters = this._groupDirectoryFactory.getExtension(modelId).getParameters();
        HashMap<String, List<I18nizableText>> errors = new HashMap<String, List<I18nizableText>>();
        Map<String, Object> parameters = this._readXMLDataHelper.readAndValidateXMLData(conf, modelId + "$", declaredParameters, errors);
        if (errors.isEmpty()) {
            return parameters;
        }
        StringBuilder sb = new StringBuilder(String.format("The group directory of id '%s' declares a model with id '%s' but some parameters are not valid:", groupId, modelId));
        for (String dataName : errors.keySet()) {
            for (I18nizableText error : (List)errors.get(dataName)) {
                sb.append("\n* '").append(dataName).append("': ").append(this._i18nUtils.translate(error));
            }
        }
        sb.append("\nThis group directory will be ignored.");
        throw new ConfigurationException(sb.toString(), conf);
    }

    private boolean _write() {
        boolean errorOccured;
        block17: {
            File backup;
            block16: {
                block15: {
                    backup = new File(__GROUP_DIRECTORIES_FILE.getPath() + ".tmp");
                    errorOccured = false;
                    try {
                        Files.copy(__GROUP_DIRECTORIES_FILE.toPath(), backup.toPath(), new CopyOption[0]);
                    }
                    catch (IOException e) {
                        if (!this.getLogger().isErrorEnabled()) break block15;
                        this.getLogger().error("Error when creating backup '" + String.valueOf(__GROUP_DIRECTORIES_FILE) + "' file", (Throwable)e);
                    }
                }
                try (FileOutputStream os = new FileOutputStream(__GROUP_DIRECTORIES_FILE);){
                    TransformerHandler th = ((SAXTransformerFactory)TransformerFactory.newInstance()).newTransformerHandler();
                    StreamResult result = new StreamResult(os);
                    th.setResult(result);
                    Properties format = new Properties();
                    format.put("method", "xml");
                    format.put("indent", "yes");
                    format.put("encoding", "UTF-8");
                    format.put("{http://xml.apache.org/xalan}indent-amount", "4");
                    th.getTransformer().setOutputProperties(format);
                    try {
                        this._toSAX(th);
                    }
                    catch (Exception e) {
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("Error when saxing the groupDirectories", (Throwable)e);
                        }
                        errorOccured = true;
                    }
                }
                catch (IOException | TransformerConfigurationException | TransformerFactoryConfigurationError e) {
                    if (!this.getLogger().isErrorEnabled()) break block16;
                    this.getLogger().error("Error when trying to modify the group directories with the configuration file " + String.valueOf(__GROUP_DIRECTORIES_FILE), e);
                }
            }
            try {
                if (errorOccured) {
                    Files.copy(backup.toPath(), __GROUP_DIRECTORIES_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this._read(true);
                }
                Files.deleteIfExists(backup.toPath());
            }
            catch (IOException e) {
                if (!this.getLogger().isErrorEnabled()) break block17;
                this.getLogger().error("Error when restoring backup '" + String.valueOf(__GROUP_DIRECTORIES_FILE) + "' file", (Throwable)e);
            }
        }
        return errorOccured;
    }

    private void _toSAX(TransformerHandler handler) throws SAXException {
        handler.startDocument();
        XMLUtils.startElement((ContentHandler)handler, (String)"groupDirectories");
        for (GroupDirectory gd : this._groupDirectories.values()) {
            this._saxGroupDirectory(gd, handler);
        }
        XMLUtils.endElement((ContentHandler)handler, (String)"groupDirectories");
        handler.endDocument();
    }

    private void _saxGroupDirectory(GroupDirectory groupDirectory, TransformerHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addCDATAAttribute("id", groupDirectory.getId());
        atts.addCDATAAttribute("modelId", groupDirectory.getGroupDirectoryModelId());
        XMLUtils.startElement((ContentHandler)handler, (String)"groupDirectory", (Attributes)atts);
        groupDirectory.getLabel().toSAX(handler, "label");
        XMLUtils.startElement((ContentHandler)handler, (String)"params");
        GroupDirectoryModel groupDirectoryModel = this._groupDirectoryFactory.getExtension(groupDirectory.getGroupDirectoryModelId());
        this._writeParameterValues(groupDirectoryModel.getParameters(), groupDirectory.getParameterValues(), handler);
        XMLUtils.endElement((ContentHandler)handler, (String)"params");
        XMLUtils.endElement((ContentHandler)handler, (String)"groupDirectory");
    }

    private void _writeParameterValues(Map<String, ? extends ElementDefinition> definitions, Map<String, Object> paramValues, TransformerHandler handler) throws SAXException {
        for (String paramName : paramValues.keySet()) {
            Object value = paramValues.get(paramName);
            ElementDefinition definition = definitions.get(paramName);
            Optional<XMLElementType> type = Optional.ofNullable(definition).map(ElementDefinition::getType).filter(XMLElementType.class::isInstance).map(XMLElementType.class::cast);
            if (!type.isPresent()) continue;
            type.get().write(handler, paramName, value);
        }
    }

    public void dispose() {
        for (GroupDirectory gd : this._groupDirectories.values()) {
            LifecycleHelper.dispose((Object)gd);
        }
        this._lastFileReading = 0L;
    }
}

