/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class GroupIdentity {
    private static final String __SEPARATOR = "#";
    private String _id;
    private String _directoryId;

    public GroupIdentity(String id, String directoryId) {
        this._id = id;
        this._directoryId = directoryId;
    }

    public static String groupIdentityToString(GroupIdentity groupIdentity) {
        return groupIdentity.getId() + __SEPARATOR + groupIdentity.getDirectoryId();
    }

    public static GroupIdentity stringToGroupIdentity(String string) {
        String id = StringUtils.substringBeforeLast((String)string, (String)__SEPARATOR);
        String groupDirectoryId = StringUtils.substringAfterLast((String)string, (String)__SEPARATOR);
        return new GroupIdentity(id, groupDirectoryId);
    }

    public String getId() {
        return this._id;
    }

    public String getDirectoryId() {
        return this._directoryId;
    }

    public int hashCode() {
        return Objects.hash(this._id, this._directoryId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupIdentity)) return false;
        GroupIdentity groupIdentity = (GroupIdentity)obj;
        if (!Objects.equals(this._id, groupIdentity._id)) return false;
        if (!Objects.equals(this._directoryId, groupIdentity._directoryId)) return false;
        return true;
    }

    public String toString() {
        return "Group [id=" + this._id + ", directory=" + this._directoryId + "]";
    }
}

