/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.group;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ametys.core.group.Group;
import org.ametys.core.group.GroupDirectoryContextHelper;
import org.ametys.core.group.GroupDirectoryDAO;
import org.ametys.core.group.GroupIdentity;
import org.ametys.core.group.directory.GroupDirectory;
import org.ametys.core.user.UserIdentity;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class GroupManager
extends AbstractLogEnabled
implements Component,
Serviceable {
    public static final String ROLE = GroupManager.class.getName();
    protected GroupDirectoryDAO _groupDirectoryDAO;
    protected GroupDirectoryContextHelper _directoryContextHelper;

    public void service(ServiceManager manager) throws ServiceException {
        this._groupDirectoryDAO = (GroupDirectoryDAO)manager.lookup(GroupDirectoryDAO.ROLE);
        this._directoryContextHelper = (GroupDirectoryContextHelper)manager.lookup(GroupDirectoryContextHelper.ROLE);
    }

    public Group getGroup(GroupIdentity groupIdentity) {
        return this.getGroup(groupIdentity.getDirectoryId(), groupIdentity.getId());
    }

    public Group getGroup(GroupDirectory groupDirectory, String groupId) {
        return groupDirectory.getGroup(groupId);
    }

    public Group getGroup(String groupDirectoryId, String groupId) {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (groupDirectory != null) {
            return this.getGroup(groupDirectory, groupId);
        }
        return null;
    }

    public Group getGroupByContext(String context, String groupId) {
        for (String directoryId : this._directoryContextHelper.getGroupDirectoriesOnContext(context)) {
            Group group = this.getGroup(directoryId, groupId);
            if (group == null) continue;
            return group;
        }
        return null;
    }

    public Set<Group> getGroups(GroupDirectory groupDirectory) {
        return groupDirectory.getGroups();
    }

    public Set<Group> getGroups(String groupDirectoryId) {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (groupDirectory != null) {
            return this.getGroups(groupDirectory);
        }
        return Collections.emptySet();
    }

    public Set<Group> getGroupsByContext(String context) {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (String directoryId : this._directoryContextHelper.getGroupDirectoriesOnContext(context)) {
            groups.addAll(this.getGroups(directoryId));
        }
        return groups;
    }

    public Set<GroupIdentity> getUserGroups(UserIdentity userIdentity) {
        HashSet<GroupIdentity> result = new HashSet<GroupIdentity>();
        for (GroupDirectory groupDirectory : this._groupDirectoryDAO.getGroupDirectories()) {
            for (String groupId : this.getUserGroups(groupDirectory, userIdentity)) {
                result.add(new GroupIdentity(groupId, groupDirectory.getId()));
            }
        }
        return result;
    }

    public Set<String> getUserGroups(GroupDirectory groupDirectory, UserIdentity userIdentity) {
        return groupDirectory.getUserGroups(userIdentity);
    }

    public Set<String> getUserGroups(String groupDirectoryId, UserIdentity userIdentity) {
        GroupDirectory groupDirectory = this._groupDirectoryDAO.getGroupDirectory(groupDirectoryId);
        if (groupDirectory != null) {
            return this.getUserGroups(groupDirectory, userIdentity);
        }
        return Collections.emptySet();
    }
}

