/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.mbean;

import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

public abstract class AbstractAmetysDynamicMBean
extends AbstractLogEnabled
implements DynamicMBean {
    protected MBeanInfo _mBeanInfo;

    public AbstractAmetysDynamicMBean() {
        this.buildDynamicMBeanInfo();
    }

    @Override
    public Object getAttribute(String attributeName) throws AttributeNotFoundException {
        if (attributeName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute name cannot be null"), "Cannot invoke a getter of " + this.getClass().getName() + " with null attribute name");
        }
        Object attribute = this._getAttribute(attributeName);
        if (attribute == null) {
            throw new AttributeNotFoundException("Cannot find " + attributeName + " attribute in " + this.getClass().getName());
        }
        return attribute;
    }

    protected abstract Object _getAttribute(String var1);

    @Override
    public AttributeList getAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames[] cannot be null"), "Cannot invoke a getter of " + this.getClass().getName());
        }
        AttributeList resultList = new AttributeList();
        if (attributeNames.length == 0) {
            return resultList;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            try {
                Object value = this.getAttribute(attributeNames[i]);
                resultList.add(new Attribute(attributeNames[i], value));
                continue;
            }
            catch (Exception e) {
                this.getLogger().error("Failed to get attribute {}", (Object)attributeNames[i], (Object)e);
            }
        }
        return resultList;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        throw new UnsupportedOperationException("No invoke method defined for this MBean.");
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new UnsupportedOperationException("Method to set attribute is not defined for this MBean.");
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        throw new UnsupportedOperationException("Method to set attributes is not defined for this MBean.");
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    private void buildDynamicMBeanInfo() {
        this._mBeanInfo = new MBeanInfo(this.getMBeanName(), this.getMBeanDescription(), this.getMBeanAttributes(), this.getMBeanConstructorInfo(), this.getMBeanOperationInfo(), this.getMBeanNotificationInfo());
    }

    protected abstract String getMBeanName();

    protected abstract String getMBeanDescription();

    protected abstract MBeanAttributeInfo[] getMBeanAttributes();

    protected MBeanConstructorInfo[] getMBeanConstructorInfo() {
        return new MBeanConstructorInfo[0];
    }

    protected MBeanOperationInfo[] getMBeanOperationInfo() {
        return new MBeanOperationInfo[0];
    }

    protected MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }
}

