/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.mbean;

import java.util.Collection;
import javax.management.MBeanAttributeInfo;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.core.mbean.AbstractAmetysDynamicMBean;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class CacheUsageMBean
extends AbstractAmetysDynamicMBean
implements Serviceable {
    public static final String ROLE = CacheUsageMBean.class.getName();
    AbstractCacheManager _cacheManager;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
    }

    public long getTotalCacheSize() {
        long sum = this._cacheManager.getAllCaches().values().stream().flatMap(Collection::stream).filter(Cache::isComputableSize).mapToLong(Cache::getMemorySize).sum();
        return sum;
    }

    @Override
    protected Object _getAttribute(String attributeName) {
        if (attributeName.equals("TotalCacheSize")) {
            return FileUtils.byteCountToDisplaySize((long)this.getTotalCacheSize());
        }
        if (attributeName.equals("TotalCacheSizeRaw")) {
            return this.getTotalCacheSize();
        }
        return null;
    }

    @Override
    protected String getMBeanName() {
        return StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)ROLE, (String)"."), (String)"MBean");
    }

    @Override
    protected String getMBeanDescription() {
        return "Cache Memory Usage";
    }

    @Override
    protected MBeanAttributeInfo[] getMBeanAttributes() {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[]{new MBeanAttributeInfo("TotalCacheSize", "String", "Total size of the different Ametys cache", true, false, false), new MBeanAttributeInfo("TotalCacheSizeRaw", "float", "Total size of the different Ametys cache in byte", true, false, false)};
        return attributes;
    }
}

