/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.mbean;

import java.lang.management.ManagementFactory;
import java.util.Hashtable;
import javax.management.DynamicMBean;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.ametys.runtime.plugin.component.AbstractThreadSafeComponentExtensionPoint;
import org.ametys.runtime.util.AmetysHomeHelper;
import org.apache.commons.lang3.Strings;

public class MBeanExtensionPoint
extends AbstractThreadSafeComponentExtensionPoint<DynamicMBean> {
    public static final String ROLE = MBeanExtensionPoint.class.getName();

    @Override
    public void initializeExtensions() throws Exception {
        super.initializeExtensions();
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        for (String ePId : this.getExtensionsIds()) {
            DynamicMBean mbean = (DynamicMBean)this.getExtension(ePId);
            String key = AmetysHomeHelper.getAmetysHome().getAbsolutePath();
            String className = mbean.getMBeanInfo().getClassName();
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("context", Strings.CS.replace(Strings.CS.remove(key, ":"), "=", "_"));
            properties.put("type", className);
            ObjectName name = new ObjectName("org.ametys", properties);
            if (mbs.isRegistered(name)) {
                mbs.unregisterMBean(name);
            }
            mbs.registerMBean(mbean, name);
        }
    }
}

