/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.ametys.core.engine.BackgroundEngineHelper;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.MigrationExtensionPoint;
import org.ametys.core.migration.action.Action;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.ActionExtensionPoint;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.handler.VersionHandler;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.ObservationManager;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.DeferredServiceable;
import org.ametys.runtime.servlet.RuntimeServlet;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.util.log.SLF4JLoggerAdapter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MigrationEngine
extends AbstractLogEnabled
implements Contextualizable,
DeferredServiceable,
Component {
    public static final String ROLE = MigrationEngine.class.getName();
    private MigrationExtensionPoint _migrationExtensionPoint;
    private MigrationExtensionPoint _migrationDataExtensionPoint;
    private ActionExtensionPoint _upgradeEP;
    private ActionExtensionPoint _initializationEP;
    private ObservationManager _observationManager;
    private ServiceManager _manager;
    private Context _context;
    private ActionData _failedAction;
    private MigrationException _failedException;

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._context = (Context)context.get((Object)"environment-context");
    }

    @Override
    public void deferredService(ServiceManager smanager) throws ServiceException {
        this._manager = smanager;
        this._migrationExtensionPoint = (MigrationExtensionPoint)smanager.lookup(MigrationExtensionPoint.ROLE);
        this._migrationDataExtensionPoint = (MigrationExtensionPoint)smanager.lookup(MigrationExtensionPoint.ROLE + "/internal");
        this._upgradeEP = (ActionExtensionPoint)smanager.lookup(ActionExtensionPoint.ROLE_UPGRADE);
        this._initializationEP = (ActionExtensionPoint)smanager.lookup(ActionExtensionPoint.ROLE_INITIALIZATION);
        if (smanager.hasService(ObservationManager.ROLE)) {
            this._observationManager = (ObservationManager)((Object)smanager.lookup(ObservationManager.ROLE));
        }
    }

    public boolean migrate() {
        this.getLogger().info("Automatic migration start");
        try {
            boolean hasToRestart = this._doMigration(this._migrationDataExtensionPoint);
            if (hasToRestart) {
                return true;
            }
            hasToRestart = this._doMigration(this._migrationExtensionPoint);
            if (hasToRestart) {
                return true;
            }
            this._notifyEndOfMigration();
            this.getLogger().info("Automatic migration finished.");
        }
        catch (MigrationException e) {
            RuntimeServlet.setMaintenanceStatus(RuntimeServlet.MaintenanceStatus.AUTOMATIC, null);
            this.getLogger().error("Error during the automatic migration", (Throwable)e);
        }
        return false;
    }

    private boolean _doMigration(MigrationExtensionPoint extPoint) throws MigrationException {
        boolean versionDeterminationFailed = false;
        ArrayList<ActionData> allInitActions = new ArrayList<ActionData>();
        ArrayList<ActionData> allUpgradeActions = new ArrayList<ActionData>();
        for (String componentId : extPoint.getExtensionsIds()) {
            MigrationComponent component = (MigrationComponent)extPoint.getExtension(componentId);
            try {
                Versions versions = this.getVersions(component);
                List<VersionList> versionLists = this._getVersionLists(versions);
                for (VersionList list : versionLists) {
                    Version versionToUpgrade = null;
                    if (list.versions().isEmpty()) {
                        Version newVersion = component.versionStorage().createVersion(list.componentId(), component, list.storageConfiguration(), list.additionalValues());
                        if (newVersion.getVersionNumber() == null) {
                            allInitActions.add(new ActionData(newVersion, this.getHighestUpgradeVersionNumber(component), component.initialization(), list.id()));
                        } else {
                            this._createAndStoreVersion(new ActionData(newVersion, newVersion.getVersionNumber(), null, list.id()), "Initial version");
                            versionToUpgrade = newVersion;
                        }
                    } else {
                        versionToUpgrade = this.getLatestVersion(list.versions());
                    }
                    if (versionToUpgrade == null) continue;
                    for (ActionConfiguration configuration : this.getUpgrades(versionToUpgrade, component.upgrades())) {
                        allUpgradeActions.add(new ActionData(versionToUpgrade, null, configuration, list.id()));
                    }
                }
            }
            catch (MigrationException e) {
                versionDeterminationFailed = true;
                this._failedException = e;
                this.getLogger().error("Error during version determination for component {}", (Object)componentId, (Object)e);
            }
        }
        if (this._executeInitializationActions(allInitActions) || this._executeUpgradeActions(allUpgradeActions)) {
            this.getLogger().info("Automatic migration is restarting the server to continue migration");
            return true;
        }
        if (versionDeterminationFailed) {
            throw new MigrationException("Version determination failed. See previous error messages for more details.");
        }
        return false;
    }

    public List<ActionConfiguration> getUpgrades(Version currentVersion, List<ActionConfiguration> availableUpgrades) throws MigrationException {
        ArrayList<ActionConfiguration> actualUpgrades = new ArrayList<ActionConfiguration>();
        String versionNumber = currentVersion.getVersionNumber();
        String higherCurrentUpgradeVersionNumber = this.getHighestUpgradeVersionNumber(currentVersion.getComponent());
        if (higherCurrentUpgradeVersionNumber.compareTo(versionNumber) < 0) {
            this.getLogger().warn("There is a version stored more recent that any version available in conf for version: {}", (Object)currentVersion.toString());
        }
        for (ActionConfiguration upgrade : availableUpgrades) {
            String from = upgrade.getFrom();
            String upgradeVersionNumber = upgrade.getVersionNumber();
            if (versionNumber.compareTo(upgradeVersionNumber) >= 0 || from != null && versionNumber.compareTo(from) > 0) continue;
            actualUpgrades.add(upgrade);
        }
        return this._removeDuplicatedActions(actualUpgrades);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Versions getVersions(MigrationComponent component) throws MigrationException {
        Map<String, Object> environmentInformation = null;
        try {
            environmentInformation = BackgroundEngineHelper.createAndEnterEngineEnvironment(this._manager, this._context, (Logger)new SLF4JLoggerAdapter(this.getLogger()));
            Versions versions = component.versionHandler.getVersions(component);
            return versions;
        }
        finally {
            BackgroundEngineHelper.leaveEngineEnvironment(environmentInformation);
        }
    }

    private List<VersionList> _getVersionLists(Versions versions) {
        if (versions instanceof VersionList) {
            VersionList versionList = (VersionList)versions;
            return List.of(versionList);
        }
        ArrayList<VersionList> versionLists = new ArrayList<VersionList>();
        for (Versions subVersions : ((VersionsContainer)versions).values()) {
            versionLists.addAll(this._getVersionLists(subVersions));
        }
        return versionLists;
    }

    public VersionList getVersionList(Versions versions, String id) {
        List<VersionList> lists = this._getVersionLists(versions);
        return lists.stream().filter(list -> id.equals(list.id())).findFirst().orElse(null);
    }

    public Version getLatestVersion(List<Version> versions) {
        return versions.stream().sorted(Comparator.comparing(Version::getVersionNumber).reversed()).findFirst().orElse(null);
    }

    private void _notifyEndOfMigration() {
        if (this._observationManager != null) {
            this._observationManager.notify(new Event("migration.ended", null, Map.of()));
        }
    }

    private boolean _executeInitializationActions(List<ActionData> allInitializationActions) throws MigrationException {
        for (ActionData action : allInitializationActions) {
            try {
                if (!this.initializeVersion(action)) continue;
                return true;
            }
            catch (MigrationException e) {
                this._failedAction = e.getFailedAction();
                this._failedException = e;
                throw e;
            }
        }
        return false;
    }

    private boolean _executeUpgradeActions(List<ActionData> allUpgradeActions) throws MigrationException {
        allUpgradeActions.sort(Comparator.comparing(action -> action.configuration().getVersionNumber()));
        if (allUpgradeActions.isEmpty()) {
            this.getLogger().debug("No upgrade to do");
        } else {
            this._logUpgradeActionsBeforeExecution(allUpgradeActions);
            for (ActionData action2 : allUpgradeActions) {
                try {
                    if (!this.upgradeVersion(action2)) continue;
                    return true;
                }
                catch (MigrationException e) {
                    this._failedAction = action2;
                    this._failedException = e;
                    throw e;
                }
            }
        }
        return false;
    }

    public boolean initializeVersion(ActionData action) throws MigrationException {
        ActionConfiguration configuration = action.configuration();
        Object versionComment = configuration != null ? configuration.getComment() : null;
        versionComment = StringUtils.isBlank((CharSequence)versionComment) ? "Automatic Initialization" : "Automatic Initialization: " + (String)versionComment;
        boolean restartRequired = false;
        if (configuration != null) {
            restartRequired = this.doAction(action, this._initializationEP);
        }
        this._createAndStoreVersion(action, (String)versionComment);
        return restartRequired;
    }

    public boolean upgradeVersion(ActionData action) throws MigrationException {
        Object versionComment = action.configuration().getComment();
        versionComment = StringUtils.isBlank((CharSequence)versionComment) ? "Automatic Upgrade" : "Automatic Upgrade: " + (String)versionComment;
        boolean restartRequired = this.doAction(action, this._upgradeEP);
        this._createAndStoreVersion(action, (String)versionComment);
        return restartRequired;
    }

    public boolean doAction(ActionData actionData, ActionExtensionPoint extensionPoint) throws MigrationException {
        Map<String, Object> environmentInformation = null;
        try {
            environmentInformation = BackgroundEngineHelper.createAndEnterEngineEnvironment(this._manager, this._context, (Logger)new SLF4JLoggerAdapter(this.getLogger()));
            Action action = (Action)extensionPoint.getExtension(actionData.configuration().getType());
            this.getLogger().info("Run action : {}", (Object)actionData.configuration());
            action.act(actionData);
            if (actionData.configuration().requiresRestart()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (MigrationException e) {
            actionData.currentVersion().setExecutionInstant(Instant.now());
            throw new MigrationException(e.getMessage(), e.getFailureMessage(), e.getCause(), actionData);
        }
        finally {
            BackgroundEngineHelper.leaveEngineEnvironment(environmentInformation);
        }
        return false;
    }

    private void _logUpgradeActionsBeforeExecution(List<ActionData> allActions) {
        if (this.getLogger().isInfoEnabled()) {
            int count = allActions.size();
            StringBuilder sb = new StringBuilder().append(count).append(count > 1 ? " pending upgrade(s):" : " pending upgrade:");
            for (ActionData action : allActions) {
                sb.append(System.lineSeparator());
                sb.append("* ").append(action.toString());
            }
            this.getLogger().info(sb.toString());
        }
    }

    private Version _createAndStoreVersion(ActionData action, String comment) throws MigrationException {
        Version currentVersion = action.currentVersion();
        Version newVersion = currentVersion.getStorage().createVersion(currentVersion.getComponentId(), currentVersion.getComponent(), currentVersion.getStorageConfiguration(), currentVersion.getAdditionalValues());
        newVersion.setExecutionInstant(Instant.now());
        newVersion.setComment(comment);
        newVersion.setVersionNumber(action.targetVersionNumber() != null ? action.targetVersionNumber() : (action.configuration() != null ? action.configuration().getVersionNumber() : "0"));
        this.getLogger().info("Store new version: {}", (Object)newVersion);
        newVersion.getStorage().storeVersion(newVersion);
        return newVersion;
    }

    public String getHighestUpgradeVersionNumber(MigrationComponent component) {
        return component.upgrades().stream().map(ActionConfiguration::getVersionNumber).sorted(Comparator.reverseOrder()).findFirst().orElse("0");
    }

    private List<ActionConfiguration> _removeDuplicatedActions(List<ActionConfiguration> actions) throws MigrationException {
        actions.sort(Comparator.comparing(ActionConfiguration::getVersionNumber).thenComparing(ActionConfiguration::getFrom, Comparator.nullsFirst(Comparator.naturalOrder())));
        List<Pair<String, String>> fromTo = actions.stream().filter(u -> StringUtils.isNotBlank((CharSequence)u.getFrom())).map(u -> Pair.of((Object)u.getFrom(), (Object)u.getVersionNumber())).collect(Collectors.toList());
        this._checkFromUpgrades(actions, fromTo);
        List<ActionConfiguration> result = actions;
        Collections.reverse(fromTo);
        for (Pair<String, String> pair : fromTo) {
            String from = (String)pair.getLeft();
            String to = (String)pair.getRight();
            result = result.stream().filter(a -> a.getVersionNumber().compareTo(from) <= 0 || to.equals(a.getVersionNumber()) && from.equals(a.getFrom()) || a.getVersionNumber().compareTo(to) > 0).collect(Collectors.toList());
        }
        return result;
    }

    protected void _checkFromUpgrades(List<ActionConfiguration> actions, List<Pair<String, String>> fromTo) throws MigrationException {
        for (Pair<String, String> pair : fromTo) {
            String from = (String)pair.getLeft();
            String to = (String)pair.getRight();
            boolean anyMatch = actions.stream().anyMatch(a -> a.getFrom() == null && to.equals(a.getVersionNumber()));
            if (anyMatch) continue;
            throw new MigrationException("The action from '" + from + "' to '" + to + "' does not contain a normal upgrade from '" + from + "'");
        }
    }

    public ActionData getFailedAction() {
        return this._failedAction;
    }

    public MigrationException getFailedException() {
        return this._failedException;
    }

    public record MigrationComponent(String id, boolean internal, String pluginName, String featureName, String versionHandlerType, VersionHandler versionHandler, VersionStorage versionStorage, VersionConfiguration versionConfiguration, ActionConfiguration initialization, List<ActionConfiguration> upgrades) {
    }

    public static sealed interface Versions
    permits VersionsContainer, VersionList {
    }

    public record VersionList(String id, List<Version> versions, String componentId, VersionConfiguration storageConfiguration, Map<String, Object> additionalValues) implements Versions
    {
    }

    public record ActionData(Version currentVersion, String targetVersionNumber, ActionConfiguration configuration, String versionListId) {
    }

    public static final class VersionsContainer
    extends HashMap<I18nizableText, Versions>
    implements Versions {
    }
}

