/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration;

import java.util.ArrayList;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.NotMigrableInSafeModeException;
import org.ametys.core.migration.action.Action;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.ActionExtensionPoint;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.handler.VersionHandler;
import org.ametys.core.migration.version.handler.VersionHandlerExtensionPoint;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.ametys.runtime.plugin.AbstractExtensionPoint;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class MigrationExtensionPoint
extends AbstractExtensionPoint<MigrationEngine.MigrationComponent>
implements Serviceable,
Configurable {
    public static final String ROLE = MigrationExtensionPoint.class.getName();
    private VersionHandlerExtensionPoint _versionHandlerEP;
    private ActionExtensionPoint _upgradeEP;
    private ActionExtensionPoint _initializationEP;
    private boolean _internal;

    public void service(ServiceManager manager) throws ServiceException {
        this._versionHandlerEP = (VersionHandlerExtensionPoint)manager.lookup(VersionHandlerExtensionPoint.ROLE);
        this._upgradeEP = (ActionExtensionPoint)manager.lookup(ActionExtensionPoint.ROLE_UPGRADE);
        this._initializationEP = (ActionExtensionPoint)manager.lookup(ActionExtensionPoint.ROLE_INITIALIZATION);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._internal = configuration.getChild("internal").getValueAsBoolean(false);
    }

    @Override
    public void addExtension(String id, String pluginName, String featureName, Configuration configuration) throws ConfigurationException {
        Configuration[] upgradeList;
        VersionStorage storage;
        VersionConfiguration handlerConfiguration;
        Configuration versionsConfiguration = configuration.getChild("versions");
        String versionHandlerType = configuration.getChild("versions").getAttribute("type");
        VersionHandler handler = (VersionHandler)this._versionHandlerEP.getExtension(versionHandlerType);
        try {
            handlerConfiguration = handler.createVersionConfiguration(versionsConfiguration);
            storage = handler.getVersionStorage(handlerConfiguration);
        }
        catch (NotMigrableInSafeModeException e) {
            this.getLogger().warn("The migration '{}' cannot be done in safe mode", (Object)id, (Object)e);
            return;
        }
        catch (MigrationException e) {
            this.getLogger().warn("Unable to find storage for  migration '{}'", (Object)id, (Object)e);
            return;
        }
        ArrayList<ActionConfiguration> upgrades = new ArrayList<ActionConfiguration>();
        for (Configuration upgradeConf : upgradeList = configuration.getChild("upgrades").getChildren("upgrade")) {
            String upgradeVersionNumber = upgradeConf.getAttribute("versionNumber");
            String type = upgradeConf.getAttribute("type");
            String from = upgradeConf.getAttribute("from", null);
            String comment = upgradeConf.getAttribute("comment", null);
            boolean restartRequired = upgradeConf.getAttributeAsBoolean("restart", false);
            Action action = (Action)this._upgradeEP.getExtension(type);
            if (action == null) {
                throw new ConfigurationException("The type '" + type + "' does not exist.", upgradeConf);
            }
            upgrades.add(action.createActionConfiguration(upgradeVersionNumber, type, comment, from, restartRequired, false, upgradeConf));
        }
        ActionConfiguration initialization = null;
        Configuration initializationConf = configuration.getChild("initialization", false);
        if (initializationConf != null) {
            String type = initializationConf.getAttribute("type");
            String comment = initializationConf.getAttribute("comment", null);
            boolean restartRequired = initializationConf.getAttributeAsBoolean("restart", false);
            Action action = (Action)this._initializationEP.getExtension(type);
            if (action == null) {
                throw new ConfigurationException("The type '" + type + "' does not exist.", initializationConf);
            }
            initialization = action.createActionConfiguration(null, type, comment, null, restartRequired, true, initializationConf);
        }
        this._extensions.put(id, new MigrationEngine.MigrationComponent(id, this._internal, pluginName, featureName, versionHandlerType, handler, storage, handlerConfiguration, initialization, upgrades));
    }

    @Override
    public void initializeExtensions() throws Exception {
    }
}

