/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.action;

import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.action.Action;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.DefaultActionConfiguration;
import org.ametys.core.migration.action.JavaActionComponent;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class JavaAction
extends AbstractLogEnabled
implements Action,
Serviceable {
    protected ServiceManager _manager;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
    }

    @Override
    public void act(MigrationEngine.ActionData actionData) throws MigrationException {
        this.getLogger().debug("Start initialization for : {}", (Object)actionData.toString());
        ActionConfiguration actionConfiguration = actionData.configuration();
        if (!(actionConfiguration instanceof JavaActionConfiguration)) {
            throw new MigrationException("Java Upgrade can only be created for a Java upgrade, this is not the case for upgrade : " + actionData.toString());
        }
        JavaActionConfiguration javaActionData = (JavaActionConfiguration)actionConfiguration;
        try {
            JavaActionComponent action = (JavaActionComponent)this._manager.lookup(javaActionData.getRole());
            action.doAction(actionData.currentVersion(), javaActionData);
        }
        catch (ClassCastException | ServiceException e) {
            throw new MigrationException("In component '" + actionData.currentVersion().getComponentId() + "', the role for the version can not be found or is not a JavaActionComponent.", e);
        }
        this.getLogger().debug("End upgrade for : {}", (Object)actionData.toString());
    }

    @Override
    public ActionConfiguration createActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, Configuration configuration) throws ConfigurationException {
        return new JavaActionConfiguration(versionNumber, type, comment, from, restartRequired, isInitialization, configuration.getAttribute("role"));
    }

    public static class JavaActionConfiguration
    extends DefaultActionConfiguration {
        private String _role;

        JavaActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, String role) {
            super(versionNumber, type, comment, from, restartRequired, isInitialization);
            this._role = role;
        }

        public String getRole() {
            return this._role;
        }

        @Override
        public String toString() {
            return super.toString() + " role : '" + this._role + "'";
        }
    }
}

