/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.action;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Map;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.action.Action;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.DefaultActionConfiguration;
import org.ametys.core.migration.version.Version;
import org.ametys.plugins.core.ui.script.ScriptHandler;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptAction
extends AbstractLogEnabled
implements Action,
Serviceable {
    private SourceResolver _sourceResolver;
    private ScriptHandler _scriptHandler;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._scriptHandler = (ScriptHandler)manager.lookup(ScriptHandler.ROLE);
    }

    @Override
    public void act(MigrationEngine.ActionData actionData) throws MigrationException {
        this.getLogger().debug("Start initialization for : {}", (Object)actionData.configuration().toString());
        ActionConfiguration actionConfiguration = actionData.configuration();
        if (!(actionConfiguration instanceof ScriptActionConfiguration)) {
            throw new MigrationException("Script Upgrade can only be created for a Script upgrade, this is not the case for upgrade : " + actionData.configuration().toString());
        }
        ScriptActionConfiguration scriptActionConfiguration = (ScriptActionConfiguration)actionConfiguration;
        Version currentVersion = actionData.currentVersion();
        String script = this._getScript(currentVersion.getComponent(), scriptActionConfiguration);
        Map<String, Logger> variables = Map.of("version", currentVersion, "actionData", actionData.configuration(), "actionConfiguration", actionData.configuration(), "logger", LoggerFactory.getLogger((String)(this.getLogger().getName() + "." + currentVersion.getComponentId())));
        Map<String, Object> scriptResult = this._scriptHandler.executeScript(script, variables, "admin");
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{(String)scriptResult.get("error"), (String)scriptResult.get("message"), (String)scriptResult.get("stacktrace")})) {
            throw new MigrationException("Error while executing script to upgrade component '" + currentVersion.getComponentId() + "' to version '" + actionData.configuration().getVersionNumber() + "'. Error : '" + String.valueOf(scriptResult.get("error")) + "', message : '" + String.valueOf(scriptResult.get("message")) + "', stacktrace : '" + String.valueOf(scriptResult.get("stacktrace")) + "'", (String)scriptResult.get("message"));
        }
        this.getLogger().debug("End upgrade for : {}", (Object)actionData.configuration().toString());
    }

    private String _getScript(MigrationEngine.MigrationComponent component, ScriptActionConfiguration scriptActionConfiguration) throws MigrationException {
        String script;
        String plugin;
        String string = plugin = scriptActionConfiguration.getPlugin() != null ? scriptActionConfiguration.getPlugin() : component.pluginName();
        if (StringUtils.isNotBlank((CharSequence)scriptActionConfiguration.getScript())) {
            script = scriptActionConfiguration.getScript();
        } else {
            String uri = "plugin:" + plugin + "://" + scriptActionConfiguration.getFile();
            Source source = null;
            try {
                source = this._sourceResolver.resolveURI(uri);
                if (!source.exists()) {
                    throw new SourceNotFoundException("URI '" + uri + "' does not exist.");
                }
                try (InputStream is = source.getInputStream();){
                    script = IOUtils.toString((InputStream)is, (String)"UTF-8");
                }
            }
            catch (MalformedURLException e) {
                throw new MigrationException("Impossible to find the script for the upgrade : " + scriptActionConfiguration.toString(), e);
            }
            catch (IOException e) {
                throw new MigrationException("Impossible to run the upgrade : " + scriptActionConfiguration.toString(), e);
            }
            finally {
                if (source != null) {
                    this._sourceResolver.release(source);
                }
            }
        }
        return "function main() { \n " + script + " \n }";
    }

    @Override
    public ActionConfiguration createActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, Configuration configuration) throws ConfigurationException {
        String file = configuration.getAttribute("file", null);
        String plugin = configuration.getAttribute("plugin", null);
        String script = configuration.getValue(null);
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{script, file})) {
            throw new ConfigurationException("The configuration must contain at least a script, or a file to fetch the script.", configuration);
        }
        return new ScriptActionConfiguration(versionNumber, type, comment, from, restartRequired, isInitialization, file, plugin, script);
    }

    public static class ScriptActionConfiguration
    extends DefaultActionConfiguration {
        private String _file;
        private String _plugin;
        private String _script;

        ScriptActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, String file, String plugin, String script) {
            super(versionNumber, type, comment, from, restartRequired, isInitialization);
            this._file = file;
            this._plugin = plugin;
            this._script = script;
        }

        public String getFile() {
            return this._file;
        }

        public String getScript() {
            return this._script;
        }

        public String getPlugin() {
            return this._plugin;
        }
    }
}

