/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.action;

import java.sql.Connection;
import java.sql.SQLException;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.SqlUpgradeAction;
import org.ametys.core.migration.version.storage.SqlVersionStorage;
import org.ametys.core.script.SQLScriptHelper;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;

public class SqlInitializationAction
extends SqlUpgradeAction {
    @Override
    public void act(MigrationEngine.ActionData actionData) throws MigrationException {
        ActionConfiguration actionConfiguration = actionData.configuration();
        if (!(actionConfiguration instanceof SqlInitializationActionConfiguration)) {
            throw new MigrationException("SQL Initialization can only be created with a SQL action, this is not the case for action: " + actionData.configuration().toString());
        }
        SqlInitializationActionConfiguration sqlActionConfiguration = (SqlInitializationActionConfiguration)actionConfiguration;
        Connection connection = null;
        try {
            boolean tableExists;
            String datasourceId = ((SqlVersionStorage.SqlVersionConfiguration)actionData.currentVersion().getStorageConfiguration()).dataSource();
            connection = ConnectionHelper.getConnection(datasourceId);
            boolean bl = tableExists = StringUtils.isNotBlank((CharSequence)sqlActionConfiguration.getTable()) ? SQLScriptHelper.tableExists(connection, sqlActionConfiguration.getTable()) : false;
            if (tableExists) {
                throw new MigrationException("Impossible to initialize the version as the table '" + sqlActionConfiguration.getTable() + "' already exists. " + actionData.configuration().toString());
            }
            this._upgrade(sqlActionConfiguration, actionData.currentVersion());
        }
        catch (SQLException e) {
            try {
                throw new MigrationException("SQL exception when trying to upgrade: " + actionData.configuration().toString(), e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(connection);
    }

    @Override
    public ActionConfiguration createActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, Configuration configuration) throws ConfigurationException {
        String file = configuration.getAttribute("file");
        String plugin = configuration.getAttribute("plugin", null);
        String table = configuration.getAttribute("table", null);
        return new SqlInitializationActionConfiguration(versionNumber, type, comment, from, restartRequired, isInitialization, file, plugin, table);
    }

    public static class SqlInitializationActionConfiguration
    extends SqlUpgradeAction.SqlUpgradeActionConfiguration {
        private String _table;

        public SqlInitializationActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, String file, String plugin, String table) {
            super(versionNumber, type, comment, from, restartRequired, isInitialization, file, plugin);
            this._table = table;
        }

        public String getTable() {
            return this._table;
        }
    }
}

