/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.action;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.action.Action;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.DefaultActionConfiguration;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.storage.SqlVersionStorage;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class SqlUpgradeAction
extends AbstractLogEnabled
implements Action,
Serviceable {
    protected SourceResolver _sourceResolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    @Override
    public void act(MigrationEngine.ActionData actionData) throws MigrationException {
        this.getLogger().debug("Start ugprade for: {}", (Object)actionData.configuration().toString());
        ActionConfiguration actionConfiguration = actionData.configuration();
        if (!(actionConfiguration instanceof SqlUpgradeActionConfiguration)) {
            throw new MigrationException("SQL Upgrade can only be created for an SQL upgrade, this is not the case for upgrade: " + actionData.configuration().toString());
        }
        SqlUpgradeActionConfiguration sqlActionConfiguration = (SqlUpgradeActionConfiguration)actionConfiguration;
        this._upgrade(sqlActionConfiguration, actionData.currentVersion());
        this.getLogger().debug("End upgrade for: {}", (Object)actionData.configuration().toString());
    }

    protected void _upgrade(SqlUpgradeActionConfiguration sqlUpgradeConfiguration, Version version) throws MigrationException {
        Connection connection = null;
        Source source = null;
        try {
            Object file = sqlUpgradeConfiguration.getFile();
            String datasourceId = ((SqlVersionStorage.SqlVersionConfiguration)version.getStorageConfiguration()).dataSource();
            connection = ConnectionHelper.getConnection(datasourceId);
            String plugin = sqlUpgradeConfiguration.getPlugin() != null ? sqlUpgradeConfiguration.getPlugin() : version.getComponent().pluginName();
            file = "plugin:" + plugin + "://" + ((String)file).replaceAll("%DATABASE_TYPE%", ConnectionHelper.getDatabaseType(connection));
            source = this._sourceResolver.resolveURI((String)file);
            try (InputStream is = source.getInputStream();){
                String script = IOUtils.toString((InputStream)is, (String)"UTF-8");
                Map<String, Object> additionalScriptValue = version.getAdditionalValues();
                for (Map.Entry<String, Object> keyValue : additionalScriptValue.entrySet()) {
                    Object value = keyValue.getValue();
                    if (!(value instanceof String)) continue;
                    script = script.replaceAll("%" + keyValue.getKey() + "%", (String)value);
                }
                SQLScriptHelper.runScript(connection, script);
            }
        }
        catch (IOException | SQLException e) {
            try {
                throw new MigrationException("Impossible to run the upgrade: " + sqlUpgradeConfiguration.toString(), e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(connection);
                this._sourceResolver.release(source);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(connection);
        this._sourceResolver.release(source);
    }

    @Override
    public ActionConfiguration createActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, Configuration configuration) throws ConfigurationException {
        String file = configuration.getAttribute("file");
        String plugin = configuration.getAttribute("plugin", null);
        return new SqlUpgradeActionConfiguration(versionNumber, type, comment, from, restartRequired, isInitialization, file, plugin);
    }

    public static class SqlUpgradeActionConfiguration
    extends DefaultActionConfiguration {
        private String _file;
        private String _plugin;

        public SqlUpgradeActionConfiguration(String versionNumber, String type, String comment, String from, boolean restartRequired, boolean isInitialization, String file, String plugin) {
            super(versionNumber, type, comment, from, restartRequired, isInitialization);
            this._file = file;
            this._plugin = plugin;
        }

        public String getFile() {
            return this._file;
        }

        public String getPlugin() {
            return this._plugin;
        }
    }
}

