/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.version;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.apache.commons.lang3.StringUtils;

public class Version {
    private MigrationEngine.MigrationComponent _component;
    private String _componentId;
    private VersionStorage _storage;
    private VersionConfiguration _configuration;
    private String _versionNumber;
    private Instant _executionInstant;
    private String _comment;
    private Map<String, Object> _additionalValues;

    public Version(MigrationEngine.MigrationComponent component, String componentId, VersionStorage storage, VersionConfiguration configuration, String versionNumber, Instant executionInstant, String comment) {
        this._component = component;
        this._componentId = componentId;
        this._storage = storage;
        this._configuration = configuration;
        this._versionNumber = versionNumber;
        this._executionInstant = executionInstant;
        this._comment = comment;
        this._additionalValues = new HashMap<String, Object>();
    }

    public String toString() {
        String log = "Version '" + this._versionNumber + "' for component '" + this._componentId + "'";
        if (StringUtils.isNotBlank((CharSequence)this._comment)) {
            log = log + " (" + this._comment + ")";
        }
        return log;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Version) {
            Version version = (Version)obj;
            return Objects.equals(this._component, version._component) && Objects.equals(this._componentId, version._componentId) && Objects.equals(this._configuration, version._configuration) && Objects.equals(this._versionNumber, version._versionNumber) && Objects.equals(this._executionInstant, version._executionInstant) && Objects.equals(this._comment, version._comment) && Objects.equals(this._additionalValues, version._additionalValues);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this._component, this._componentId, this._configuration, this._versionNumber, this._executionInstant, this._comment, this._additionalValues);
    }

    public MigrationEngine.MigrationComponent getComponent() {
        return this._component;
    }

    public String getComponentId() {
        return this._componentId;
    }

    public VersionStorage getStorage() {
        return this._storage;
    }

    public VersionConfiguration getStorageConfiguration() {
        return this._configuration;
    }

    public String getVersionNumber() {
        return this._versionNumber;
    }

    public Instant getExecutionInstant() {
        return this._executionInstant;
    }

    public String getComment() {
        return this._comment;
    }

    public void setVersionNumber(String versionNumber) {
        this._versionNumber = versionNumber;
    }

    public void setExecutionInstant(Instant executionInstant) {
        this._executionInstant = executionInstant;
    }

    public void setComment(String comment) {
        this._comment = comment;
    }

    public Object addAdditionalValue(String key, Object value) {
        return this._additionalValues.put(key, value);
    }

    public Map<String, Object> getAdditionalValues() {
        return this._additionalValues;
    }
}

