/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.version.handler;

import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.NotMigrableInSafeModeException;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.handler.JavaVersionHandlerComponent;
import org.ametys.core.migration.version.handler.VersionHandler;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.ametys.core.migration.version.storage.VersionStorageExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

public class JavaVersionHandler
extends AbstractLogEnabled
implements VersionHandler,
Serviceable {
    private ServiceManager _manager;
    private VersionStorageExtensionPoint _storageExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._storageExtensionPoint = (VersionStorageExtensionPoint)manager.lookup(VersionStorageExtensionPoint.ROLE);
    }

    @Override
    public VersionStorage getVersionStorage(VersionConfiguration configuration) throws MigrationException {
        if (!(configuration instanceof JavaVersionConfiguration)) {
            throw new MigrationException("The version configuration object should be an instance of JavaVersionConfiguration");
        }
        JavaVersionConfiguration javaConfiguration = (JavaVersionConfiguration)configuration;
        return (VersionStorage)this._storageExtensionPoint.getExtension(javaConfiguration.storage());
    }

    @Override
    public MigrationEngine.VersionsContainer getVersions(MigrationEngine.MigrationComponent component) throws MigrationException {
        JavaVersionHandlerComponent handler;
        VersionConfiguration configuration = component.versionConfiguration();
        if (!(configuration instanceof JavaVersionConfiguration)) {
            throw new MigrationException("The version configuration object should be an instance of JavaVersionConfiguration");
        }
        JavaVersionConfiguration javaConfiguration = (JavaVersionConfiguration)configuration;
        try {
            handler = (JavaVersionHandlerComponent)this._manager.lookup(javaConfiguration.role());
        }
        catch (ClassCastException | ServiceException e) {
            throw new MigrationException("In component '" + component.id() + "', the role '" + javaConfiguration.role() + "' for the version can not be found or is not a JavaVersionHandlerComponent.", e);
        }
        return handler.getVersions(component);
    }

    @Override
    public VersionConfiguration createVersionConfiguration(Configuration configuration) throws ConfigurationException, NotMigrableInSafeModeException {
        return new JavaVersionConfiguration(configuration.getAttribute("role"), configuration.getAttribute("storage"), configuration);
    }

    public record JavaVersionConfiguration(String role, String storage, Configuration configuration) implements VersionConfiguration
    {
    }
}

