/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.version.handler;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.NotMigrableInSafeModeException;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.handler.ScriptVersionHandlerScriptHandler;
import org.ametys.core.migration.version.handler.VersionHandler;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.ametys.core.migration.version.storage.VersionStorageExtensionPoint;
import org.ametys.plugins.core.ui.script.ScriptHandler;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.slf4j.LoggerFactory;

public class ScriptVersionHandler
extends AbstractLogEnabled
implements VersionHandler,
Serviceable {
    private SourceResolver _sourceResolver;
    private ScriptHandler _scriptHandler;
    private VersionStorageExtensionPoint _storageExtensionPoint;

    public void service(ServiceManager manager) throws ServiceException {
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
        this._scriptHandler = (ScriptHandler)manager.lookup(ScriptVersionHandlerScriptHandler.COMPONENT_ROLE);
        this._storageExtensionPoint = (VersionStorageExtensionPoint)manager.lookup(VersionStorageExtensionPoint.ROLE);
    }

    @Override
    public VersionStorage getVersionStorage(VersionConfiguration configuration) throws MigrationException {
        if (!(configuration instanceof ScriptVersionConfiguration)) {
            throw new MigrationException("The version configuration object should be an instance of JavaVersionConfiguration");
        }
        ScriptVersionConfiguration scriptConfiguration = (ScriptVersionConfiguration)configuration;
        return (VersionStorage)this._storageExtensionPoint.getExtension(scriptConfiguration.storage());
    }

    @Override
    public MigrationEngine.Versions getVersions(MigrationEngine.MigrationComponent component) throws MigrationException {
        try {
            Object resultObject = this._executeScript(component);
            return this._getVersions(resultObject);
        }
        catch (RuntimeException e) {
            throw new MigrationException("Error while getting version by script for component : '" + component.id() + "'", e);
        }
    }

    private MigrationEngine.Versions _getVersions(Object resultObject) throws MigrationException {
        List versions;
        Version[] versions2;
        if (resultObject instanceof MigrationEngine.VersionList) {
            MigrationEngine.VersionList list = (MigrationEngine.VersionList)resultObject;
            return list;
        }
        if (resultObject instanceof Version) {
            Version version = (Version)resultObject;
            String id = version.getComponentId();
            return new MigrationEngine.VersionList(id, this._filterList(List.of(version)), id, version.getStorageConfiguration(), null);
        }
        if (resultObject instanceof Version[] && (versions2 = (Version[])resultObject).length > 0) {
            String id = versions2[0].getComponentId();
            return new MigrationEngine.VersionList(id, this._filterList(List.of(Arrays.asList(versions2))), id, versions2[0].getStorageConfiguration(), null);
        }
        if (resultObject instanceof List && (versions = (List)resultObject).size() > 0) {
            String id = ((Version)versions.get(0)).getComponentId();
            return new MigrationEngine.VersionList(id, this._filterList(versions), id, ((Version)versions.get(0)).getStorageConfiguration(), null);
        }
        if (resultObject instanceof Map) {
            Map versions3 = (Map)resultObject;
            MigrationEngine.VersionList list = this._getVersionListFromMap(versions3);
            if (list != null) {
                return list;
            }
            MigrationEngine.VersionsContainer allVersions = new MigrationEngine.VersionsContainer();
            for (Map.Entry version : versions3.entrySet()) {
                Object k = version.getKey();
                if (k instanceof String) {
                    String subComponentId = (String)k;
                    allVersions.put(new I18nizableText(subComponentId), this._getVersions(version.getValue()));
                    continue;
                }
                k = version.getKey();
                if (k instanceof I18nizableText) {
                    I18nizableText i18n = (I18nizableText)k;
                    allVersions.put(i18n, this._getVersions(version.getValue()));
                    continue;
                }
                throw new MigrationException("A map returned by a version script should be either <I18nizableText, ?> or <String, ?>");
            }
            return allVersions;
        }
        throw new MigrationException("The script returned an unexpected object, it must be a Version, Version[], List<Version> or Map<String, List<Version>>: " + String.valueOf(resultObject));
    }

    private MigrationEngine.VersionList _getVersionListFromMap(Map versions) {
        Object v;
        Set keys = versions.keySet();
        if (keys.size() == 5 && (v = versions.get("id")) instanceof String) {
            String id = (String)v;
            v = versions.get("versions");
            if (v instanceof List) {
                List list = (List)v;
                v = versions.get("componentId");
                if (v instanceof String) {
                    String subComponentId = (String)v;
                    if ((versions.get("versionConfiguration") == null || versions.get("versionConfiguration") instanceof VersionConfiguration) && (v = versions.get("additionalValues")) instanceof Map) {
                        Map values = (Map)v;
                        return new MigrationEngine.VersionList(id, this._filterList(list), subComponentId, (VersionConfiguration)versions.get("versionConfiguration"), values);
                    }
                }
            }
        }
        return null;
    }

    private List<Version> _filterList(List<?> versions) {
        return versions.stream().filter(Version.class::isInstance).map(Version.class::cast).filter(v -> v.getVersionNumber() != null).toList();
    }

    private Object _executeScript(MigrationEngine.MigrationComponent component) throws MigrationException {
        VersionConfiguration versionConfiguration = component.versionConfiguration();
        if (!(versionConfiguration instanceof ScriptVersionConfiguration)) {
            throw new MigrationException("The version configuration object should be an instance of ScriptVersionConfiguration");
        }
        ScriptVersionConfiguration scriptVersionConfiguration = (ScriptVersionConfiguration)versionConfiguration;
        String script = scriptVersionConfiguration.script();
        Map<String, Object> variables = this._getVariables(component, scriptVersionConfiguration);
        Map<String, Object> scriptResult = this._scriptHandler.executeScript(script, variables, "admin");
        if (!StringUtils.isAllBlank((CharSequence[])new CharSequence[]{(String)scriptResult.get("error"), (String)scriptResult.get("message"), (String)scriptResult.get("stacktrace")})) {
            throw new MigrationException("Error while executing script to get version for component '" + component.id() + "'. Error : '" + String.valueOf(scriptResult.get("error")) + "', message : '" + String.valueOf(scriptResult.get("message")) + "', stacktrace : '" + String.valueOf(scriptResult.get("stacktrace")) + "'");
        }
        return scriptResult.get("result");
    }

    private Map<String, Object> _getVariables(MigrationEngine.MigrationComponent component, ScriptVersionConfiguration scriptVersionConfiguration) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("component", component);
        variables.put("componentId", component.id());
        variables.put("versionConfiguration", scriptVersionConfiguration.configuration());
        variables.put("logger", LoggerFactory.getLogger((String)(this.getLogger().getName() + "." + component.id())));
        return variables;
    }

    private String _getScript(Configuration versionConfiguration) throws ConfigurationException {
        String script = versionConfiguration.getValue(null);
        if (StringUtils.isBlank((CharSequence)script)) {
            String uri = versionConfiguration.getAttribute("uri", "");
            if (StringUtils.isBlank((CharSequence)uri)) {
                throw new ConfigurationException("The script should be directly written in the version, or in a linked file.", versionConfiguration);
            }
            Source source = null;
            try {
                source = this._sourceResolver.resolveURI(uri);
                if (!source.exists()) {
                    throw new ConfigurationException("URI '" + uri + "' does not exist.", versionConfiguration);
                }
                try (InputStream is = source.getInputStream();){
                    script = IOUtils.toString((InputStream)is, (String)"UTF-8");
                }
            }
            catch (IOException e) {
                throw new ConfigurationException("Impossible to run the script at uri '" + uri + "'.", versionConfiguration, (Throwable)e);
            }
            finally {
                if (source != null) {
                    this._sourceResolver.release(source);
                }
            }
        }
        return "function main() { \n " + script + " \n }";
    }

    @Override
    public VersionConfiguration createVersionConfiguration(Configuration configuration) throws ConfigurationException, NotMigrableInSafeModeException {
        String uri = configuration.getAttribute("uri", null);
        String script = this._getScript(configuration);
        String storage = configuration.getAttribute("storage");
        return new ScriptVersionConfiguration(uri, script, storage, configuration);
    }

    public record ScriptVersionConfiguration(String uri, String script, String storage, Configuration configuration) implements VersionConfiguration
    {
    }
}

