/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.version.handler;

import java.util.List;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.NotMigrableInSafeModeException;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.handler.VersionHandler;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.ametys.core.migration.version.storage.VersionStorageExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class StorageBasedVersionHandler
extends AbstractLogEnabled
implements VersionHandler,
Serviceable,
Configurable {
    private VersionStorageExtensionPoint _versionStorageEP;
    private VersionStorage _versionStorage;
    private String _versionStorageId;

    public void service(ServiceManager manager) throws ServiceException {
        this._versionStorageEP = (VersionStorageExtensionPoint)manager.lookup(VersionStorageExtensionPoint.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this._versionStorageId = configuration.getChild("version-storage").getValue(null);
        if (StringUtils.isBlank((CharSequence)this._versionStorageId)) {
            throw new ConfigurationException("<version-storage> is mandatory and should not be blank", configuration);
        }
        this._versionStorage = (VersionStorage)this._versionStorageEP.getExtension(this._versionStorageId);
    }

    @Override
    public VersionStorage getVersionStorage(VersionConfiguration configuration) throws MigrationException {
        return this._versionStorage;
    }

    @Override
    public MigrationEngine.Versions getVersions(MigrationEngine.MigrationComponent component) throws MigrationException {
        this.getLogger().debug("Get all versions for component id: " + component.id());
        List<Version> versions = this._versionStorage.getVersions(component.id(), component.versionConfiguration(), component);
        return new MigrationEngine.VersionList(component.id(), versions, component.id(), component.versionConfiguration(), null);
    }

    @Override
    public VersionConfiguration createVersionConfiguration(Configuration versionConfiguration) throws ConfigurationException, NotMigrableInSafeModeException {
        return this._versionStorage.createVersionConfiguration(versionConfiguration);
    }
}

