/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.migration.version.storage;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.ametys.core.datasource.ConnectionHelper;
import org.ametys.core.migration.MigrationEngine;
import org.ametys.core.migration.MigrationException;
import org.ametys.core.migration.NotMigrableInSafeModeException;
import org.ametys.core.migration.action.ActionConfiguration;
import org.ametys.core.migration.action.SqlInitializationAction;
import org.ametys.core.migration.action.SqlUpgradeAction;
import org.ametys.core.migration.version.Version;
import org.ametys.core.migration.version.VersionConfiguration;
import org.ametys.core.migration.version.storage.VersionStorage;
import org.ametys.core.script.SQLScriptHelper;
import org.ametys.runtime.config.Config;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.ametys.runtime.plugin.component.PluginAware;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public class SqlVersionStorage
extends AbstractLogEnabled
implements VersionStorage,
Serviceable,
PluginAware,
Initializable {
    private static final String __VERSION_TABLE_NAME = "Ametys_Versions";
    private static final String __COLUMN_COMPONENT = "component_identifier";
    private static final String __COLUMN_VERSION = "ametys_version_number";
    private static final String __COLUMN_DATE = "execution_date";
    private static final String __COLUMN_COMMENT = "execution_comment";
    private static final String __AMETYS_VERSIONS_COMPONENT_ID = "ametys.versions.table";
    private static final TreeMap<String, String> __AMETYS_VERSIONS_UDPATES = new TreeMap();
    private MigrationEngine _migrationEngine;
    private String _plugin;
    private String _feature;
    private String _id;
    private ActionConfiguration _internalInitialization;
    private List<ActionConfiguration> _internalUpgrades = new ArrayList<ActionConfiguration>();
    private List<String> _checkedDataSources = new ArrayList<String>();

    @Override
    public void setPluginInfo(String pluginName, String featureName, String id) {
        this._id = id;
        this._plugin = pluginName;
        this._feature = featureName;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this._migrationEngine = (MigrationEngine)manager.lookup(MigrationEngine.ROLE);
    }

    public void initialize() throws Exception {
        for (String versionNumber : __AMETYS_VERSIONS_UDPATES.keySet()) {
            String comment = __AMETYS_VERSIONS_UDPATES.get(versionNumber);
            this._internalUpgrades.add(new SqlUpgradeAction.SqlUpgradeActionConfiguration(versionNumber, "sql", comment, null, false, false, String.format("scripts/%%DATABASE_TYPE%%/ametys_versions/v%s.sql", versionNumber), "core"));
        }
        String highestVersionNumber = __AMETYS_VERSIONS_UDPATES.lastKey();
        this._internalInitialization = new SqlInitializationAction.SqlInitializationActionConfiguration(highestVersionNumber, "sql", null, null, false, true, "scripts/%DATABASE_TYPE%/ametys_versions.sql", "core", null);
    }

    @Override
    public String getId() {
        return this._id;
    }

    @Override
    public List<Version> getVersions(String componentId, VersionConfiguration configuration, MigrationEngine.MigrationComponent component) throws MigrationException {
        if (!(configuration instanceof SqlVersionConfiguration)) {
            throw new MigrationException("The version configuration object should be an instance of SqlVersionConfiguration");
        }
        SqlVersionConfiguration sqlConfiguration = (SqlVersionConfiguration)configuration;
        String dataSourceId = sqlConfiguration.dataSource();
        this._internalUpgrade(dataSourceId);
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(dataSourceId);
            List<Version> list = this._getVersionsForComponent(connection, componentId, component, sqlConfiguration);
            return list;
        }
        catch (SQLException e) {
            String message = String.format("Error while getting the versions for: %s (dataSource: %s)", componentId, dataSourceId);
            throw new MigrationException(message, e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Version> _getVersionsForComponent(Connection connection, String componentId, MigrationEngine.MigrationComponent component, VersionConfiguration configuration) throws SQLException {
        ArrayList<Version> arrayList;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "SELECT * FROM Ametys_Versions WHERE component_identifier = ? ORDER BY ametys_version_number DESC";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, componentId);
            rs = stmt.executeQuery();
            ArrayList<Version> versions = new ArrayList<Version>();
            while (rs.next()) {
                String versionNumber = rs.getString(__COLUMN_VERSION);
                Timestamp timestamp = rs.getTimestamp(__COLUMN_DATE);
                String comment = rs.getString(__COLUMN_COMMENT);
                Version version = new Version(component, componentId, this, configuration, versionNumber, timestamp.toInstant(), comment);
                versions.add(version);
            }
            arrayList = versions;
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(rs);
            ConnectionHelper.cleanup(stmt);
            throw throwable;
        }
        ConnectionHelper.cleanup(rs);
        ConnectionHelper.cleanup(stmt);
        return arrayList;
    }

    @Override
    public Version createVersion(String componentId, MigrationEngine.MigrationComponent component, VersionConfiguration storageConfiguration, Map<String, Object> additionalValues) throws MigrationException {
        Version version = VersionStorage.super.createVersion(componentId, component, storageConfiguration, additionalValues);
        if (component.initialization() == null) {
            version.setVersionNumber("0");
        }
        return version;
    }

    @Override
    public void storeVersion(Version version) throws MigrationException {
        this.getLogger().debug("Add version for: {}", (Object)version.toString());
        VersionConfiguration versionConfiguration = version.getStorageConfiguration();
        if (!(versionConfiguration instanceof SqlVersionConfiguration)) {
            throw new MigrationException("Impossible to create a SQL version in a non-sql version: " + version.toString());
        }
        SqlVersionConfiguration configuration = (SqlVersionConfiguration)versionConfiguration;
        String dataSourceId = configuration.dataSource();
        this._internalUpgrade(dataSourceId);
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(dataSourceId);
            this._addVersion(connection, version);
        }
        catch (SQLException e) {
            throw new MigrationException("Error during SQL query to set the new version for: " + version.toString() + " (dataSource: " + dataSourceId + ")", e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
        this.getLogger().debug("End add version for: {}", (Object)version.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _addVersion(Connection connection, Version version) throws SQLException {
        PreparedStatement stmt = null;
        try {
            String sql = "INSERT INTO Ametys_Versions (component_identifier, ametys_version_number, execution_date, execution_comment) VALUES (?, ?, ?, ?)";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, version.getComponentId());
            stmt.setString(2, version.getVersionNumber());
            stmt.setTimestamp(3, Timestamp.from(version.getExecutionInstant()));
            stmt.setString(4, version.getComment());
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            ConnectionHelper.cleanup(stmt);
            throw throwable;
        }
        ConnectionHelper.cleanup(stmt);
    }

    @Override
    public void removeVersion(String componentId, String versionNumber, VersionConfiguration configuration) throws MigrationException {
        this.getLogger().debug("Start remove version {} for component: {}", (Object)versionNumber, (Object)componentId);
        if (!(configuration instanceof SqlVersionConfiguration)) {
            throw new MigrationException("The version configuration object should be an instance of SqlVersionConfiguration");
        }
        SqlVersionConfiguration sqlConfiguration = (SqlVersionConfiguration)configuration;
        String dataSourceId = sqlConfiguration.dataSource();
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            this._internalUpgrade(dataSourceId);
            connection = ConnectionHelper.getConnection(dataSourceId);
            String sql = "DELETE FROM Ametys_Versions WHERE component_identifier = ? AND ametys_version_number = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, componentId);
            stmt.setString(2, versionNumber);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String message = String.format("Error while getting the versions for %s (datasource: %s)", componentId, dataSourceId);
                throw new MigrationException(message, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        this.getLogger().debug("End remove version {} for component: {}", (Object)versionNumber, (Object)componentId);
    }

    @Override
    public void removeAllVersions(String componentIdentifier, VersionConfiguration versionConfiguration) throws MigrationException {
        this.getLogger().debug("Start remove all version for component: {}", (Object)componentIdentifier);
        if (!(versionConfiguration instanceof SqlVersionConfiguration)) {
            throw new MigrationException("The version configuration object should be an instance of SqlVersionConfiguration");
        }
        String dataSourceId = ((SqlVersionConfiguration)versionConfiguration).dataSource();
        Connection connection = null;
        PreparedStatement stmt = null;
        try {
            this._internalUpgrade(dataSourceId);
            connection = ConnectionHelper.getConnection(dataSourceId);
            String sql = "DELETE FROM Ametys_Versions WHERE component_identifier = ?";
            stmt = connection.prepareStatement(sql);
            stmt.setString(1, componentIdentifier);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                String message = String.format("Error while getting the versions for %s (datasource: %s)", componentIdentifier, dataSourceId);
                throw new MigrationException(message, e);
            }
            catch (Throwable throwable) {
                ConnectionHelper.cleanup(stmt);
                ConnectionHelper.cleanup(connection);
                throw throwable;
            }
        }
        ConnectionHelper.cleanup(stmt);
        ConnectionHelper.cleanup(connection);
        this.getLogger().debug("End remove all version for component: {}", (Object)componentIdentifier);
    }

    private void _internalUpgrade(String dataSource) throws MigrationException {
        if (this._checkedDataSources.contains(dataSource)) {
            return;
        }
        this.getLogger().info("Check internal versions table for datasource {}", (Object)dataSource);
        this._checkedDataSources.add(dataSource);
        MigrationEngine.MigrationComponent component = this._createVersionsTableMigrationComponent(dataSource);
        Connection connection = null;
        try {
            connection = ConnectionHelper.getConnection(dataSource);
            if (!SQLScriptHelper.tableExists(connection, __VERSION_TABLE_NAME)) {
                Version version = this.createVersion(component.id(), component, new SqlVersionConfiguration(dataSource), null);
                if (this._migrationEngine.initializeVersion(new MigrationEngine.ActionData(version, null, this._internalInitialization, null))) {
                    throw new UnsupportedOperationException("Restarting after internal intialization is not supported");
                }
            } else {
                List<Version> versions = this._getVersionsForComponent(connection, component.id(), component, new SqlVersionConfiguration(dataSource));
                Version currentVersion = versions.stream().sorted(Comparator.comparing(Version::getVersionNumber).reversed()).findFirst().orElse(null);
                if (currentVersion == null) {
                    currentVersion = this.createVersion(component.id(), component, new SqlVersionConfiguration(dataSource), null);
                    currentVersion.setVersionNumber("0");
                }
                List<ActionConfiguration> upgrades = this._migrationEngine.getUpgrades(currentVersion, this._internalUpgrades);
                for (ActionConfiguration action : upgrades) {
                    if (!this._migrationEngine.upgradeVersion(new MigrationEngine.ActionData(currentVersion, null, action, null))) continue;
                    throw new UnsupportedOperationException("Restarting after internal upgrade is not supported");
                }
            }
        }
        catch (SQLException e) {
            String errorMsg = String.format("Error during SQL tables initialization for data source id: '%s'.", StringUtils.defaultString((String)dataSource));
            throw new MigrationException(errorMsg, e);
        }
        finally {
            ConnectionHelper.cleanup(connection);
        }
    }

    private MigrationEngine.MigrationComponent _createVersionsTableMigrationComponent(String datasource) {
        return new MigrationEngine.MigrationComponent(__AMETYS_VERSIONS_COMPONENT_ID, false, this._plugin, this._feature, "sql", null, this, new SqlVersionConfiguration(datasource), this._internalInitialization, this._internalUpgrades);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VersionConfiguration createVersionConfiguration(Configuration versionConfiguration) throws ConfigurationException, NotMigrableInSafeModeException {
        String dataSourceId = null;
        Configuration dataSourceConf = versionConfiguration.getChild("datasource");
        String dataSourceConfParam = dataSourceConf.getValue(null);
        if (StringUtils.isBlank((CharSequence)dataSourceConfParam)) {
            throw new ConfigurationException("The 'datasource' configuration node must be defined and contain non empty value.", dataSourceConf);
        }
        String dataSourceConfType = dataSourceConf.getAttribute("type", null);
        if (Strings.CS.equals(dataSourceConfType, "config")) {
            if (Config.getInstance() == null) throw new NotMigrableInSafeModeException("Cannot get datasource for config parameter '" + dataSourceConfParam + "' in safe mode");
            dataSourceId = (String)Config.getInstance().getValue(dataSourceConfParam);
            return new SqlVersionConfiguration(dataSourceId);
        } else {
            dataSourceId = dataSourceConfParam;
        }
        return new SqlVersionConfiguration(dataSourceId);
    }

    static {
        __AMETYS_VERSIONS_UDPATES.put("20210401T0000", "Modify column 'component_identifier' to enlarge it to 250 characters.");
    }

    public record SqlVersionConfiguration(String dataSource) implements VersionConfiguration
    {
    }
}

