/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize;

import com.google.debugging.sourcemap.SourceMapFormat;
import com.google.debugging.sourcemap.SourceMapGeneratorFactory;
import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.minimize.SourceMapCache;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.minimize.HashCache;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public abstract class AbstractMinimizeManager
extends AbstractLogEnabled
implements Serviceable {
    private static final Pattern __SOURCEMAP_SOURCE_NAME = Pattern.compile("\\s*\"sources\"\\s*:\\s*\\[\\s*([^\\]]+)\\]", 40);
    private static final Pattern SOURCE_MAP_SOURCE = Pattern.compile("\"([^\"]+)\"");
    protected SourceMapCache _sourceMapCache;
    protected ProxiedContextPathProvider _proxiedContextPathProvider;
    protected SourceResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        this._sourceMapCache = (SourceMapCache)smanager.lookup(SourceMapCache.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)smanager.lookup(ProxiedContextPathProvider.ROLE);
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
    }

    public String minimizeAndAggregateURIs(List<HashCache.UriData> uris, String fileName, boolean generateSourceMap) {
        SourceMapGeneratorV3 sourceMapGenerator = generateSourceMap ? (SourceMapGeneratorV3)SourceMapGeneratorFactory.getInstance((SourceMapFormat)SourceMapFormat.V3) : null;
        int totalLineCount = 0;
        StringBuffer sb = new StringBuffer();
        for (HashCache.UriData uri : uris) {
            String lastLine;
            int lineCount;
            Object content = this.getMinimizedContent(uri.getUri(), "");
            if (!((String)content).endsWith("\n") && !((String)content).endsWith("\n\r")) {
                content = (String)content + "\n";
            }
            String[] lines = ((String)content).split("\r\n|\r|\n", -1);
            for (lineCount = lines.length; lineCount > 0 && StringUtils.isEmpty((CharSequence)lines[lineCount - 1]); --lineCount) {
            }
            boolean hasMedia = StringUtils.isNotEmpty((CharSequence)uri.getMedia());
            if (hasMedia) {
                ++totalLineCount;
            }
            String string = lastLine = lineCount > 0 ? lines[lineCount - 1] : null;
            if (this.isSourceMappingURLLine(lastLine)) {
                String mapURL = this.getSourceMappingURL(lastLine);
                content = this.removeSourceMappingURLLine((String)content);
                if (generateSourceMap) {
                    this.addSourceMap(sourceMapGenerator, totalLineCount, (String)content, uri.getUri(), mapURL);
                }
                --lineCount;
            } else if (lastLine != null && lines.length > lineCount) {
                content = ((String)content).substring(0, ((String)content).lastIndexOf(lastLine) + lastLine.length()).trim() + "\n";
            }
            totalLineCount += lineCount;
            sb.append((String)(hasMedia ? this.applyMediaToContent((String)content, uri.getMedia()) : content));
        }
        this._generateSourceMap(sourceMapGenerator, sb, fileName, fileName + ".map", generateSourceMap);
        return sb.toString();
    }

    protected String applyMediaToContent(String content, String media) {
        return "\n" + content;
    }

    private void _generateSourceMap(SourceMapGeneratorV3 sourceMapGenerator, StringBuffer sb, String fileName, String sourceMapName, boolean generateSourceMap) {
        try {
            if (generateSourceMap) {
                StringBuilder sbMap = new StringBuilder();
                sourceMapGenerator.appendTo((Appendable)sbMap, fileName);
                this._sourceMapCache.put(sourceMapName, sbMap.toString(), 0L);
            }
            sb.append("\n" + this.formatSourceMappingURL(sourceMapName));
        }
        catch (IOException e) {
            this.getLogger().error("Unable to create final source map for minimized file", (Throwable)e);
        }
    }

    protected String convertSourceMapURIs(String content, String uri) throws URISyntaxException {
        String sourceMapContent = content;
        Matcher matcher = __SOURCEMAP_SOURCE_NAME.matcher(sourceMapContent);
        if (matcher.find()) {
            String originalSources = matcher.group(1);
            StringBuffer sb = new StringBuffer();
            Matcher sourcesMatcher = SOURCE_MAP_SOURCE.matcher(originalSources);
            while (sourcesMatcher.find()) {
                String source = sourcesMatcher.group(1);
                if (source.equals("unused")) {
                    sourcesMatcher.appendReplacement(sb, "\"\"");
                    continue;
                }
                if (source.startsWith("sources-unavailable://")) {
                    sourcesMatcher.appendReplacement(sb, "\"" + source + "\"");
                    continue;
                }
                if (source.indexOf("/") == 0) continue;
                String realSourceUri = this._proxiedContextPathProvider.getContextPath() + new URI(StringUtils.substringBeforeLast((String)uri, (String)"/") + "/" + source).normalize().toString();
                sourcesMatcher.appendReplacement(sb, Matcher.quoteReplacement(sourcesMatcher.group(0).replace(source, realSourceUri)));
            }
            sourcesMatcher.appendTail(sb);
            sourceMapContent = sourceMapContent.replace(originalSources, sb.toString());
        }
        return sourceMapContent;
    }

    public void validateAndOutputMinimizedFile(Source source, OutputStream out, String sourceUri) throws IOException {
        String lastLine;
        int lineCount;
        String fileContent;
        try (InputStream is = source.getInputStream();){
            fileContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        String[] lines = fileContent.split("\r\n|\r|\n", -1);
        for (lineCount = lines.length; lineCount > 0 && StringUtils.isEmpty((CharSequence)lines[lineCount - 1]); --lineCount) {
        }
        String string = lastLine = lineCount > 0 ? lines[lineCount - 1] : null;
        if (this.isSourceMappingURLLine(lastLine)) {
            String mapURL = this.getSourceMappingURL(lastLine);
            String uriToResolve = sourceUri.indexOf(47) > -1 ? sourceUri.substring(0, sourceUri.lastIndexOf("/") + 1) + mapURL : mapURL;
            Source mapSource = null;
            try {
                mapSource = this._resolver.resolveURI(uriToResolve);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (mapSource == null || !mapSource.exists()) {
                fileContent = this.removeSourceMappingURLLine(fileContent);
            }
        }
        out.write(fileContent.getBytes(StandardCharsets.UTF_8));
    }

    protected abstract boolean isSourceMappingURLLine(String var1);

    protected abstract String getSourceMappingURL(String var1);

    protected abstract String removeSourceMappingURLLine(String var1);

    protected abstract String formatSourceMappingURL(String var1);

    protected abstract String getMinimizedContent(String var1, String var2);

    protected abstract void addSourceMap(SourceMapGeneratorV3 var1, int var2, String var3, String var4, String var5);
}

