/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.minimize.SourceMapCache;
import org.ametys.core.resources.SimpleResourceHandler;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.excalibur.source.Source;

public abstract class AbstractSourceMapResourceHandler
extends SimpleResourceHandler {
    protected SourceMapCache _sourceMapCache;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._sourceMapCache = (SourceMapCache)manager.lookup(SourceMapCache.ROLE);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, boolean readForDownload) throws IOException, ProcessingException {
        Source source = this._getExistingSource(location);
        if (source == null && (source = this._getAlternateSource(location, objectModel)) == null) {
            throw new ResourceNotFoundException("Resource not found for URI : " + location);
        }
        this._source = source;
        return source;
    }

    protected abstract Source _getAlternateSource(String var1, Map var2) throws ProcessingException, IOException;

    protected Source _getExistingSource(String location) {
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (source == null || !source.exists()) {
            this._resolver.release(source);
            return null;
        }
        return source;
    }
}

