/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize;

import java.io.IOException;
import java.util.Map;
import org.ametys.core.cache.AbstractCacheManager;
import org.ametys.core.cache.Cache;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class SourceMapCache
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable {
    public static final String ROLE = SourceMapCache.class.getName();
    protected AbstractCacheManager _cacheManager;
    protected SourceResolver _sourceResolver;

    public void service(ServiceManager manager) throws ServiceException {
        this._cacheManager = (AbstractCacheManager)manager.lookup(AbstractCacheManager.ROLE);
        this._sourceResolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void initialize() throws Exception {
        this._cacheManager.createMemoryCache(ROLE, new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_SOURCE_MAP_LABEL"), new I18nizableText("plugin.core", "PLUGINS_CORE_CACHE_SOURCE_MAP_DESCRIPTION"), true, null);
    }

    public void put(String uri, String content, Long lastModified) throws IOException {
        Source sourceMapData = this._sourceResolver.resolveURI("sourcemap://" + uri, null, Map.of("content", content, "lastmodified", lastModified));
        this._getCache().put(uri, sourceMapData);
    }

    public Source get(String uri) {
        return this._getCache().get(uri);
    }

    private Cache<String, Source> _getCache() {
        return this._cacheManager.get(ROLE);
    }
}

