/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceNotFoundException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.TimeStampValidity;

public class SourceMapSourceFactory
implements SourceFactory {
    public static final String LAST_MODIFIED = "lastmodified";
    public static final String CONTENT = "content";
    public static final String SCHEME = "sourcemap";

    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException {
        return new SourceMapSource(location, (String)parameters.get(CONTENT), (Long)parameters.get(LAST_MODIFIED));
    }

    public void release(Source source) {
    }

    public static final class SourceMapSource
    implements Source {
        private String _content;
        private Long _lastModified;
        private String _location;
        private TimeStampValidity _timeStampValidity;

        public SourceMapSource(String location, String content, Long lastModified) {
            this._location = location;
            this._content = content;
            this._lastModified = lastModified;
        }

        public boolean exists() {
            return true;
        }

        public InputStream getInputStream() throws IOException, SourceNotFoundException {
            return new ByteArrayInputStream(this._content.getBytes(StandardCharsets.UTF_8));
        }

        public String getURI() {
            return this._location;
        }

        public String getScheme() {
            return SourceMapSourceFactory.SCHEME;
        }

        public SourceValidity getValidity() {
            if (this._timeStampValidity == null) {
                this._timeStampValidity = new TimeStampValidity(this._lastModified.longValue());
            }
            return this._timeStampValidity;
        }

        public void refresh() {
        }

        public String getMimeType() {
            return "application/json";
        }

        public long getContentLength() {
            return this._content.length();
        }

        public long getLastModified() {
            return this._lastModified;
        }
    }
}

