/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.minimize.AbstractSourceMapResourceHandler;
import org.ametys.core.minimize.css.MinimizeCSSManager;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;

public class CSSSourceMapResourceHandler
extends AbstractSourceMapResourceHandler {
    protected MinimizeCSSManager _cssMinimizeManager;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._cssMinimizeManager = (MinimizeCSSManager)manager.lookup(MinimizeCSSManager.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    @Override
    protected Source _getAlternateSource(String location, Map objectModel) throws IOException {
        Source source = null;
        try {
            String resolvedLocation = this._jsassResourceURIExtensionPoint.resolve(location);
            source = this._sourceMapCache.get(resolvedLocation != null ? resolvedLocation : location);
        }
        catch (URISyntaxException e) {
            this.getLogger().error("Unable to resolve the uri because the syntax '" + location + "' is not supported ", (Throwable)e);
        }
        if (source == null) {
            source = this._generateCssSourceMap(objectModel, location);
        }
        return source;
    }

    private Source _generateCssSourceMap(Map objectModel, String location) throws IOException {
        String originalUri = "/" + Strings.CS.removeEnd(ObjectModelHelper.getRequest((Map)objectModel).getSitemapURI(), (CharSequence)".map");
        Source sourceResolved = this._resolver.resolveURI("cocoon:" + originalUri);
        if (sourceResolved != null && sourceResolved.exists()) {
            Source source;
            block10: {
                InputStream inputStream = sourceResolved.getInputStream();
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)baos);
                    String sourceMapKey = this._jsassResourceURIExtensionPoint.resolve(location);
                    this._cssMinimizeManager.minimizeCss(baos.toString(StandardCharsets.UTF_8.toString()), originalUri, sourceMapKey, sourceResolved.getLastModified());
                    source = this._sourceMapCache.get(sourceMapKey);
                    if (inputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (URISyntaxException | ProcessingException e) {
                        this.getLogger().error("Unable to compile CSS file", e);
                    }
                }
                inputStream.close();
            }
            return source;
        } else {
            this._resolver.release(sourceResolved);
        }
        return null;
    }
}

