/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class JSASSFixHelper {
    private static final Pattern SOURCEMAP_SOURCES_PATTERN = Pattern.compile("^(.*\"sources\":\\[)(.*?)(\\].*)$");
    private static final Pattern SOURCEMAP_SOURCE_PATTERN = Pattern.compile("\"([^\"]*)\"");

    private JSASSFixHelper() {
    }

    public static String fixJsassSourceMap(String sourceMap) {
        Matcher matcher = SOURCEMAP_SOURCES_PATTERN.matcher(sourceMap);
        if (matcher.matches()) {
            StringBuilder result = new StringBuilder();
            result.append(matcher.group(1));
            String sources = matcher.group(2);
            Matcher sourceMatcher = SOURCEMAP_SOURCE_PATTERN.matcher(sources);
            while (sourceMatcher.find()) {
                String source = sourceMatcher.group(1);
                try {
                    if (source.startsWith("/") || new URI(source).isAbsolute()) continue;
                    sourceMatcher.appendReplacement(result, "\"/$1\"");
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            sourceMatcher.appendTail(result);
            result.append(matcher.group(3));
            return result.toString();
        }
        return sourceMap;
    }
}

