/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import org.ametys.core.minimize.AbstractMinimizeManager;
import org.ametys.core.minimize.css.AmetysCssImporter;
import org.ametys.core.minimize.css.JSASSFixHelper;
import org.ametys.plugins.core.ui.resources.css.CSSFileHelper;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.util.NetUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;

public class MinimizeCSSManager
extends AbstractMinimizeManager
implements Component,
Initializable {
    public static final String ROLE = MinimizeCSSManager.class.getName();
    private Compiler _jsassCompiler;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;

    public void initialize() throws Exception {
        this._jsassCompiler = new Compiler();
    }

    @Override
    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)smanager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    public String minimizeCss(String code, String location) throws ProcessingException, IOException {
        return this.minimizeCss(code, location, null, null);
    }

    public String minimizeCss(String code, String location, String sourceMapKey, Long lastModified) throws IOException, ProcessingException {
        try {
            boolean withSourceMap = location != null && sourceMapKey != null && lastModified != null;
            Output output = this._minimizeCss(location, "", code, withSourceMap);
            Object sourceResult = output.getCss();
            if (StringUtils.isBlank((CharSequence)sourceResult)) {
                return "";
            }
            if (withSourceMap) {
                String unfixedSourceMap = super.convertSourceMapURIs(output.getSourceMap(), "/");
                String sourceMap = JSASSFixHelper.fixJsassSourceMap(unfixedSourceMap);
                this._sourceMapCache.put(sourceMapKey, sourceMap, lastModified);
            }
            sourceResult = ((String)sourceResult).trim();
            if (location != null) {
                String fileName = location.substring(location.lastIndexOf("/") + 1);
                sourceResult = (String)sourceResult + "\n" + this.formatSourceMappingURL(fileName + ".map");
            }
            return sourceResult;
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("An error occurred while converting source map of " + location, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getMinimizedContent(String fileUri, String nestedParentFilesName) {
        Source cssSource = null;
        try {
            String originalContent;
            String minimizeFileUri = Strings.CS.endsWith((CharSequence)fileUri, (CharSequence)".min.css") ? fileUri : Strings.CS.removeEnd(fileUri, (CharSequence)".css") + ".min.css";
            URI minimizeUri = new URI(minimizeFileUri);
            String uriToResolve = minimizeUri.isAbsolute() ? minimizeFileUri : "cocoon:/" + NetUtils.normalize((String)minimizeFileUri);
            cssSource = this._resolver.resolveURI(uriToResolve);
            try (InputStream is = cssSource.getInputStream();
                 BOMInputStream bomIs = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(is)).get();){
                originalContent = IOUtils.toString((InputStream)bomIs, (String)"UTF-8");
            }
            originalContent = CSSFileHelper.replaceRelativeUri(originalContent, minimizeFileUri, this._jsassResourceURIExtensionPoint, this._proxiedContextPathProvider.getContextPath(), this._proxiedContextPathProvider.getContextPath());
            StringBuffer result = new StringBuffer();
            result.append("/*! File : ");
            result.append(nestedParentFilesName);
            result.append(fileUri);
            result.append(" */\n");
            result.append(originalContent);
            String string = result.toString();
            this._resolver.release(cssSource);
            return string;
        }
        catch (Exception e) {
            this.getLogger().error("Cannot open CSS for aggregation " + fileUri, (Throwable)e);
            String string = "/** ERROR " + e.getMessage() + "*/\n";
            return string;
        }
        finally {
            this._resolver.release(cssSource);
        }
    }

    @Override
    protected String applyMediaToContent(String content, String media) {
        return "@media " + media + " {\n" + (Strings.CS.endsWith((CharSequence)content, (CharSequence)"\n") ? content.substring(0, content.length() - 1) + "}\n" : content + "}");
    }

    private Output _minimizeCss(String cssUri, String nestedParentFilesName, String originalContent, boolean generateSourceMap) throws ProcessingException {
        try {
            URI outputPath;
            URI inputPath;
            String content = originalContent;
            Options options = new Options();
            options.setOutputStyle(OutputStyle.COMPRESSED);
            if (cssUri != null && generateSourceMap) {
                options.setSourceMapFile(new URI("unused"));
                options.setOmitSourceMapUrl(true);
            }
            AmetysCssImporter cssImporter = new AmetysCssImporter();
            options.getImporters().add(cssImporter);
            if (cssUri != null) {
                URI uri = new URI(cssUri);
                String contextualizedUri = uri.isAbsolute() ? this._jsassResourceURIExtensionPoint.resolve(uri.toString()) : uri.toString();
                content = CSSFileHelper.replaceRelativeUri(content, contextualizedUri, this._jsassResourceURIExtensionPoint, this._proxiedContextPathProvider.getContextPath(), this._proxiedContextPathProvider.getContextPath());
                content = this._resolveImportUrl(content, nestedParentFilesName + cssUri + " > ");
                inputPath = new URI("." + cssUri);
                outputPath = this._computeMinimizedUri(FilenameUtils.getName((String)cssUri));
            } else {
                options.setSourceMapFile(null);
                inputPath = new URI("unknown-location");
                outputPath = new URI("unknown-location");
            }
            return this._jsassCompiler.compileString(content, inputPath, outputPath, options);
        }
        catch (CompilationException | URISyntaxException e) {
            throw new ProcessingException("Unable to Minimize the css file: " + cssUri, e);
        }
    }

    private URI _computeMinimizedUri(String sourceMapUri) throws URISyntaxException {
        return new URI(Strings.CS.removeEnd(sourceMapUri, (CharSequence)".css") + ".min.css");
    }

    private String _resolveImportUrl(String content, String nestedParentFilesName) throws URISyntaxException {
        StringBuffer sb = new StringBuffer();
        Matcher importMatcher = CSSFileHelper.IMPORT_PATTERN.matcher(content);
        while (importMatcher.find()) {
            String cssUrl = importMatcher.group(1);
            String media = importMatcher.group(2);
            if (cssUrl == null || cssUrl.startsWith("http://") || cssUrl.startsWith("https://") || cssUrl.startsWith("//")) continue;
            URI uri = new URI(cssUrl);
            String uriToCompile = uri.isAbsolute() ? cssUrl : Strings.CS.removeStart(cssUrl, (CharSequence)this._proxiedContextPathProvider.getContextPath());
            Object importedContent = this.getMinimizedContent(uriToCompile, nestedParentFilesName);
            importedContent = (String)importedContent + " /*! File end : " + nestedParentFilesName + uriToCompile + " */";
            if (StringUtils.isNotEmpty((CharSequence)media)) {
                importedContent = this.applyMediaToContent((String)importedContent, media);
            }
            importMatcher.appendReplacement(sb, Matcher.quoteReplacement((String)importedContent));
        }
        importMatcher.appendTail(sb);
        return sb.toString();
    }

    @Override
    protected void addSourceMap(SourceMapGeneratorV3 sourceMapGenerator, int lineCount, String fileContent, String fileUri, String sourceMapUri) {
        try {
            String sourceMapContent;
            block19: {
                sourceMapContent = null;
                String sourceMapKey = fileUri.indexOf(47) > -1 ? new URI(StringUtils.substringBeforeLast((String)fileUri, (String)"/") + "/" + sourceMapUri).normalize().toString() : sourceMapUri;
                sourceMapKey = Strings.CS.removeStart(sourceMapKey, (CharSequence)this._proxiedContextPathProvider.getContextPath());
                Source mapSource = this._sourceMapCache.get(sourceMapKey);
                if (mapSource != null) {
                    try (InputStream is = mapSource.getInputStream();){
                        sourceMapContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                }
                Object uriToResolve = new URI(sourceMapKey).isAbsolute() ? sourceMapKey : "cocoon:/" + sourceMapKey;
                try {
                    mapSource = this._resolver.resolveURI((String)uriToResolve);
                    if (!mapSource.exists()) break block19;
                    try (InputStream is = mapSource.getInputStream();){
                        sourceMapContent = IOUtils.toString((InputStream)is, (String)"UTF-8");
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (sourceMapContent != null) {
                sourceMapContent = JSASSFixHelper.fixJsassSourceMap(sourceMapContent);
                sourceMapGenerator.mergeMapSection(lineCount + 1, 0, sourceMapContent);
            } else {
                this.getLogger().warn("Unable to retrieve source map when aggregating hash file, for sourceMappingURL '" + sourceMapUri + "' of file '" + fileUri + "'");
            }
        }
        catch (SourceMapParseException | IOException | IllegalStateException | URISyntaxException e) {
            this.getLogger().error("Unable to merge source map of '" + fileUri + "' to the CSS minimized source map", e);
        }
    }

    @Override
    protected boolean isSourceMappingURLLine(String line) {
        return line != null && line.startsWith("/*# sourceMappingURL=") && line.endsWith(" */");
    }

    @Override
    protected String getSourceMappingURL(String line) {
        return line.substring("/*# sourceMappingURL=".length(), line.length() - " */".length()).trim();
    }

    @Override
    protected String removeSourceMappingURLLine(String content) {
        return content.substring(0, content.lastIndexOf("/*# sourceMappingURL="));
    }

    @Override
    protected String formatSourceMappingURL(String sourceMapName) {
        return "/*# sourceMappingURL=" + sourceMapName + " */\n";
    }
}

