/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.minimize.css.MinimizeCSSManager;
import org.ametys.core.resources.SimpleResourceHandler;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class MinimizedCSSResourceHandler
extends SimpleResourceHandler {
    protected MinimizeCSSManager _cssMinimizeManager;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;
    private String _minimizedUri;
    private String _originalUri;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._cssMinimizeManager = (MinimizeCSSManager)manager.lookup(MinimizeCSSManager.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, boolean readForDownload) throws IOException, ProcessingException {
        this._minimizedUri = location;
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        if (source == null || !source.exists()) {
            this._resolver.release(source);
            String sitemapURI = "/" + Strings.CS.removeEnd(ObjectModelHelper.getRequest((Map)objectModel).getSitemapURI(), (CharSequence)".min.css") + ".css";
            source = super.setup("cocoon:" + sitemapURI, objectModel, par, readForDownload);
            this._originalUri = sitemapURI;
        }
        this._source = source;
        return this._source;
    }

    @Override
    public Serializable getKey() {
        Serializable key = super.getKey();
        return String.valueOf(key) + "*" + this._minimizedUri;
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        if (this._originalUri == null) {
            this._cssMinimizeManager.validateAndOutputMinimizedFile(this._source, out, this._minimizedUri);
            return;
        }
        try (InputStream is = this._source.getInputStream();
             ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            IOUtils.copy((InputStream)is, (OutputStream)bos);
            String code = bos.toString("UTF-8");
            boolean lazyLoadSourceMap = DevMode.DEVMODE.PRODUCTION.equals((Object)DevMode.getDeveloperMode(ObjectModelHelper.getRequest((Map)this._objectModel)));
            String resolvedOriginalUri = null;
            try {
                resolvedOriginalUri = this._jsassResourceURIExtensionPoint.resolve(this._originalUri);
            }
            catch (URISyntaxException e) {
                this.getLogger().error("Unable to resolve URI location because URI syntax '" + this._originalUri + "' is not supported", (Throwable)e);
            }
            String result = resolvedOriginalUri == null || lazyLoadSourceMap ? this._cssMinimizeManager.minimizeCss(code, resolvedOriginalUri) : this._cssMinimizeManager.minimizeCss(code, this._originalUri, resolvedOriginalUri + ".map", this._source.getLastModified());
            out.write(result.getBytes(StandardCharsets.UTF_8));
        }
    }
}

