/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css.sass;

import io.bit3.jsass.CompilationException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.ametys.core.minimize.css.sass.MinimizeSassManager;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.reading.ServiceableReader;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.xml.sax.SAXException;

public class CompileSassReader
extends ServiceableReader
implements CacheableProcessingComponent {
    private MinimizeSassManager _minimizeSassManager;
    private SourceResolver _resolver;

    public void service(ServiceManager smanager) throws ServiceException {
        super.service(smanager);
        this._minimizeSassManager = (MinimizeSassManager)smanager.lookup(MinimizeSassManager.ROLE);
        this._resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        try {
            Source src = this._resolver.resolveURI(this.source);
            if (!src.exists()) {
                throw new ProcessingException("Unable to resolve sass file '" + this.source + "' for compilation, source does not exist");
            }
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                try (InputStream is = src.getInputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)bos);
                }
                String compileCss = this._minimizeSassManager.compileCss(bos.toString(StandardCharsets.UTF_8.toString()), this.source, this.source, false, 0L);
                IOUtils.write((String)compileCss, (OutputStream)this.out, (Charset)StandardCharsets.UTF_8);
                IOUtils.closeQuietly((OutputStream)this.out);
            }
            catch (CompilationException | URISyntaxException e) {
                throw new ProcessingException("Unable to compile sass file '" + this.source + "'", e);
            }
        }
        catch (IOException e) {
            throw new ProcessingException("Unable to resolve sass file '" + this.source + "' for compilation", (Throwable)e);
        }
    }

    public Serializable getKey() {
        return this.source;
    }

    public SourceValidity getValidity() {
        return new NOPValidity();
    }

    public String getMimeType() {
        return "text/css";
    }
}

