/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.css.sass;

import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import io.bit3.jsass.OutputStyle;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.stream.Collectors;
import org.ametys.core.minimize.SourceMapCache;
import org.ametys.core.minimize.css.JSASSFixHelper;
import org.ametys.core.minimize.css.sass.AmetysScssImporter;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.resources.css.CSSFileHelper;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.ametys.plugins.core.ui.resources.css.sass.SassFunctionsProvider;
import org.ametys.plugins.core.ui.resources.css.sass.SassFunctionsProviderExtensionPoint;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.Strings;
import org.apache.excalibur.source.SourceResolver;

public class MinimizeSassManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Initializable,
Contextualizable {
    public static final String ROLE = MinimizeSassManager.class.getName();
    private Compiler _jsassCompiler;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;
    private SourceResolver _resolver;
    private List<SassFunctionsProvider> _sassFunctionsProviders;
    private SourceMapCache _sourceMapCache;
    private ProxiedContextPathProvider _proxiedContextPathProvider;
    private Context _context;

    public void initialize() throws Exception {
        this._jsassCompiler = new Compiler();
    }

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    public void service(ServiceManager smanager) throws ServiceException {
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)smanager.lookup(JSASSResourceURIExtensionPoint.ROLE);
        this._resolver = (SourceResolver)smanager.lookup(SourceResolver.ROLE);
        SassFunctionsProviderExtensionPoint sassFunctionsProviderEP = (SassFunctionsProviderExtensionPoint)smanager.lookup(SassFunctionsProviderExtensionPoint.ROLE);
        this._sassFunctionsProviders = sassFunctionsProviderEP.getExtensionsIds().stream().map(id -> (SassFunctionsProvider)sassFunctionsProviderEP.getExtension((String)id)).collect(Collectors.toList());
        this._sourceMapCache = (SourceMapCache)smanager.lookup(SourceMapCache.ROLE);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)smanager.lookup(ProxiedContextPathProvider.ROLE);
    }

    public String compileCss(String content, String sassLocation, String location, boolean minimize, long lastModified) throws URISyntaxException, CompilationException, IOException {
        String externalContextPath = this._proxiedContextPathProvider.getContextPath();
        String contextualizedUri = null;
        try {
            contextualizedUri = this._jsassResourceURIExtensionPoint.resolve(sassLocation);
        }
        catch (URISyntaxException e) {
            this.getLogger().error("Unable to resolve URI location because URI syntax '" + location + "' is not supported", (Throwable)e);
        }
        if (contextualizedUri != null && contextualizedUri.contains("://")) {
            throw new URISyntaxException(contextualizedUri, "Unable to compile Sass file, unsupported URI starts with unknown protocol");
        }
        URI uri = contextualizedUri != null ? new URI(externalContextPath + contextualizedUri) : null;
        String locationFilename = FilenameUtils.getName((String)location);
        Output compiledString = this._compileCss(content, locationFilename, uri, minimize, FilenameUtils.getExtension((String)sassLocation));
        String compileResult = compiledString.getCss();
        if (uri != null) {
            Object result = CSSFileHelper.replaceRelativeResourcesUri(compileResult, contextualizedUri, this._jsassResourceURIExtensionPoint, externalContextPath);
            if (!((String)result).equals(compileResult)) {
                this.getLogger().warn("Relative path found in '{}'. Relative paths inside SASS files need to be avoided, as it will offset the source mapping. Please use functions ('pluginUrl()' or similar helpers) instead.", (Object)uri.toString());
            }
            String sourceMap = compiledString.getSourceMap();
            String sourceMapName = !minimize ? uri.toString() + ".map" : Strings.CS.removeEnd(uri.toString(), (CharSequence)".scss") + ".css.map";
            sourceMap = JSASSFixHelper.fixJsassSourceMap(sourceMap);
            String cacheKey = Strings.CS.removeStart(sourceMapName, (CharSequence)externalContextPath);
            this._sourceMapCache.put(cacheKey, sourceMap, lastModified);
            result = (String)result + "/*# sourceMappingURL=" + FilenameUtils.getName((String)sourceMapName) + " */\n";
            return result;
        }
        return compileResult;
    }

    public String generateCssSourceMap(String content, String location, String extension, String internalContextPath, String externalContextPath, boolean minimize, long lastModified) throws URISyntaxException, CompilationException, IOException {
        String contextualizedUri = null;
        try {
            contextualizedUri = this._jsassResourceURIExtensionPoint.resolve(Strings.CS.removeEnd(location, (CharSequence)".map"));
        }
        catch (URISyntaxException e) {
            this.getLogger().error("Unable to resolve URI location because URI syntax '" + location + "' is not supported", (Throwable)e);
            return null;
        }
        if (contextualizedUri.contains("://")) {
            throw new URISyntaxException(contextualizedUri, "Unable to compile Sass file, unsupported URI '" + location + "' contains unknown protocol");
        }
        URI sassUri = new URI(externalContextPath + (String)(!minimize ? contextualizedUri : Strings.CS.removeEnd(contextualizedUri, (CharSequence)".css") + "." + extension));
        String locationFilename = FilenameUtils.getName((String)(Strings.CS.removeEnd(sassUri.toString(), (CharSequence)("." + extension)) + (!minimize ? ".css" : ".min.css")));
        Output compiledString = this._compileCss(content, locationFilename, sassUri, minimize, extension);
        String sourceMap = compiledString.getSourceMap();
        URI uri = new URI(externalContextPath + contextualizedUri);
        String sourceMapName = !minimize ? uri.toString() + ".map" : Strings.CS.removeEnd(uri.toString(), (CharSequence)("." + extension)) + ".css.map";
        sourceMap = JSASSFixHelper.fixJsassSourceMap(sourceMap);
        String cacheKey = Strings.CS.removeStart(sourceMapName, (CharSequence)externalContextPath);
        this._sourceMapCache.put(cacheKey, sourceMap, lastModified);
        return sourceMap;
    }

    private Output _compileCss(String content, String fileName, URI uri, boolean minimize, String extension) throws URISyntaxException, CompilationException {
        URI outputPath;
        URI inputPath;
        String externalContextPath = this._proxiedContextPathProvider.getContextPath();
        Options options = new Options();
        AmetysScssImporter importer = new AmetysScssImporter(ContextHelper.getRequest((Context)this._context).getContextPath(), externalContextPath, this._resolver, this._jsassResourceURIExtensionPoint);
        options.getImporters().add(importer);
        options.getFunctionProviders().addAll(this._sassFunctionsProviders);
        if (minimize) {
            options.setOutputStyle(OutputStyle.COMPRESSED);
        }
        if (fileName != null && uri != null) {
            options.setSourceMapFile(new URI("unused"));
            options.setOmitSourceMapUrl(true);
            inputPath = new URI("." + uri.toString());
            outputPath = new URI(fileName);
        } else {
            options.setSourceMapFile(null);
            inputPath = new URI("unknown-location");
            outputPath = new URI("unknown-location");
        }
        return this._jsassCompiler.compileString(content, inputPath, outputPath, options);
    }
}

