/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.js;

import com.google.debugging.sourcemap.SourceMapGeneratorV3;
import com.google.debugging.sourcemap.SourceMapParseException;
import com.google.javascript.jscomp.CompilationLevel;
import com.google.javascript.jscomp.Compiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.Result;
import com.google.javascript.jscomp.SourceFile;
import com.google.javascript.jscomp.WarningLevel;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.minimize.AbstractMinimizeManager;
import org.apache.avalon.framework.component.Component;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.util.NetUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.excalibur.source.Source;

public class MinimizeJSManager
extends AbstractMinimizeManager
implements Component {
    public static final String ROLE = MinimizeJSManager.class.getName();
    private static final Pattern __SOURCEMAP_FILE_NAME = Pattern.compile(".*\"file\"\\s*:\\s*\"([^\"]+)\".*", 40);
    private static final Pattern __SOURCEMAP_LINE = Pattern.compile("^(.*)(\n//# sourceMappingURL=.*)\r?\n?$", 32);

    public String minimizeJS(String code, String location) throws ProcessingException, IOException {
        return this.minimizeJS(code, location, null, null);
    }

    public String minimizeJS(String code, String location, String sourceMapKey, Long lastModified) throws IOException, ProcessingException {
        String fileName = StringUtils.substringAfterLast((String)location, (String)"/");
        boolean withSourceMap = sourceMapKey != null && lastModified != null;
        Compiler compiler = this._minimizeJS(code, fileName, withSourceMap);
        Object sourceResult = compiler.toSource();
        if (withSourceMap) {
            StringBuilder sb = new StringBuilder();
            compiler.getSourceMap().appendTo((Appendable)sb, fileName);
            this._sourceMapCache.put(sourceMapKey, sb.toString(), lastModified);
            sourceResult = (String)sourceResult + "\n" + this.formatSourceMappingURL(fileName + ".map");
        }
        return sourceResult;
    }

    public String generateJSSourceMap(String code, String location, String sourceMapKey, Long lastModified) throws ProcessingException, IOException {
        String fileName = location.substring(location.lastIndexOf("/") + 1);
        Compiler compiler = this._minimizeJS(code, fileName, true);
        StringBuilder sb = new StringBuilder();
        compiler.toSource();
        compiler.getSourceMap().appendTo((Appendable)sb, fileName);
        String sourceMap = sb.toString();
        this._sourceMapCache.put(sourceMapKey, sourceMap, lastModified);
        return sourceMap;
    }

    private Compiler _minimizeJS(String code, String fileName, boolean withSourceMap) throws ProcessingException {
        Compiler compiler = new Compiler();
        CompilerOptions options = new CompilerOptions();
        options.setTracerMode(CompilerOptions.TracerMode.OFF);
        WarningLevel.QUIET.setOptionsForWarningLevel(options);
        if (withSourceMap) {
            options.setSourceMapOutputPath("unused");
        }
        options.setEmitUseStrict(false);
        options.setOutputCharset(StandardCharsets.UTF_8);
        CompilationLevel level = CompilationLevel.WHITESPACE_ONLY;
        level.setOptionsForCompilationLevel(options);
        SourceFile file = SourceFile.fromCode((String)fileName, (String)code);
        Result result = compiler.compile(Collections.emptyList(), Arrays.asList(file), options);
        if (result.errors.size() > 0) {
            StringBuilder errorsString = new StringBuilder();
            errorsString.append("Unable to minimize " + fileName);
            for (JSError error : result.errors) {
                errorsString.append("\n" + error.toString());
            }
            throw new ProcessingException(errorsString.toString());
        }
        return compiler;
    }

    @Override
    protected void addSourceMap(SourceMapGeneratorV3 sourceMapGenerator, int lineCount, String fileContent, String fileUri, String sourceMapUri) {
        block12: {
            try {
                String sourceMapContent;
                String sourceMapCacheKey = fileUri.indexOf(47) > -1 ? fileUri.substring(0, fileUri.lastIndexOf("/") + 1) + sourceMapUri : sourceMapUri;
                Source mapSource = this._sourceMapCache.get(sourceMapCacheKey);
                if (mapSource == null) {
                    Object uriToResolve = new URI(sourceMapCacheKey).isAbsolute() ? sourceMapCacheKey : "cocoon:/" + sourceMapCacheKey;
                    try {
                        mapSource = this._resolver.resolveURI((String)uriToResolve);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (mapSource == null || !mapSource.exists()) break block12;
                try (InputStream is = mapSource.getInputStream();){
                    sourceMapContent = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                Matcher fileMatcher = __SOURCEMAP_FILE_NAME.matcher(sourceMapContent);
                if (fileMatcher.matches()) {
                    sourceMapContent = sourceMapContent.replaceFirst("\"file\":\"" + fileMatcher.group(1) + "\"", "\"file\":\"" + this._proxiedContextPathProvider.getContextPath() + fileUri + "\"");
                }
                sourceMapContent = super.convertSourceMapURIs(sourceMapContent, fileUri);
                sourceMapGenerator.mergeMapSection(lineCount + 2, 0, sourceMapContent);
            }
            catch (SourceMapParseException | IOException | IllegalStateException | URISyntaxException e) {
                this.getLogger().error("Unable to retrieve source map when aggregating hash file, for sourceMappingURL '" + sourceMapUri + "' of file '" + fileUri + "'", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getMinimizedContent(String uri, String nestedParentFilesName) {
        StringBuffer sb;
        block15: {
            sb = new StringBuffer();
            sb.append("/** File : " + uri + " */\n");
            sb.append("document_currentScript = (function() { a = document.createElement('script'); a.src='" + this._proxiedContextPathProvider.getContextPath() + uri + "'; return a; })(); try {\n");
            Source jssource = null;
            String suffix = null;
            try {
                String s;
                String minimizeFileUri = Strings.CS.endsWith((CharSequence)uri, (CharSequence)".min.js") ? uri : Strings.CS.removeEnd(uri, (CharSequence)".js") + ".min.js";
                URI minimizeUri = new URI(minimizeFileUri);
                String uriToResolve = minimizeUri.isAbsolute() ? minimizeFileUri : "cocoon:/" + NetUtils.normalize((String)minimizeFileUri);
                jssource = this._resolver.resolveURI(uriToResolve);
                try (InputStream is = jssource.getInputStream();){
                    s = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                }
                s = s.replaceAll("document\\.currentScript", "document_currentScript");
                Matcher matcher = __SOURCEMAP_LINE.matcher(s);
                if (matcher.matches()) {
                    s = matcher.group(1);
                    suffix = matcher.group(2) + "\n";
                }
                sb.append(s);
                this._resolver.release(jssource);
                sb.append("} catch (e) { console.error(\"" + uri + "\\n\", e) }");
            }
            catch (Exception e) {
                this.getLogger().error("Cannot minimize JS for file '" + uri + "'.", (Throwable)e);
                sb.append("throw new Error('" + StringEscapeUtils.escapeEcmaScript((String)ExceptionUtils.getRootCause((Throwable)e).getMessage()) + "');");
                break block15;
            }
            finally {
                this._resolver.release(jssource);
                sb.append("} catch (e) { console.error(\"" + uri + "\\n\", e) }");
                if (StringUtils.isNotBlank(suffix)) {
                    sb.append(suffix);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)suffix)) {
                sb.append(suffix);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    protected boolean isSourceMappingURLLine(String line) {
        return line != null && line.startsWith("//# sourceMappingURL=");
    }

    @Override
    protected String getSourceMappingURL(String line) {
        return line.substring("//# sourceMappingURL=".length()).trim();
    }

    @Override
    protected String removeSourceMappingURLLine(String content) {
        return content.substring(0, content.lastIndexOf("//# sourceMappingURL="));
    }

    @Override
    protected String formatSourceMappingURL(String sourceMapName) {
        return "//# sourceMappingURL=" + sourceMapName + "\n";
    }
}

