/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.minimize.js;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.minimize.js.MinimizeJSManager;
import org.ametys.core.resources.JSResourceHandler;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class MinimizedJSResourceHandler
extends JSResourceHandler {
    protected MinimizeJSManager _jSMinimizeManager;
    private String _realFileUri;

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._jSMinimizeManager = (MinimizeJSManager)manager.lookup(MinimizeJSManager.ROLE);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, boolean readForDownload) throws IOException, ProcessingException {
        this._requestedLocation = location;
        this._objectModel = objectModel;
        this._setExpiresToNoCache = false;
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        if (source == null || !source.exists()) {
            this._resolver.release(source);
            String realLocation = location.substring(0, location.length() - ".min.js".length()) + ".js";
            source = super.setup(realLocation, objectModel, par, readForDownload);
            this._realFileUri = realLocation;
        }
        this._source = source;
        return this._source;
    }

    @Override
    public Serializable getKey() {
        Serializable key = super.getKey();
        return String.valueOf(key) + "*" + this._requestedLocation;
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        if (this._realFileUri == null) {
            this._jSMinimizeManager.validateAndOutputMinimizedFile(this._source, out, this._requestedLocation);
            return;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            super.generate(bos);
            String code = bos.toString("UTF-8");
            String locale = this.getLocale();
            boolean lazyLoadSourceMap = DevMode.DEVMODE.PRODUCTION.equals((Object)DevMode.getDeveloperMode(ObjectModelHelper.getRequest((Map)this._objectModel)));
            String result = lazyLoadSourceMap ? this._jSMinimizeManager.minimizeJS(code, this._realFileUri) : this._jSMinimizeManager.minimizeJS(code, this._realFileUri, this._realFileUri + ".map" + (String)(locale != null ? "#" + locale : ""), this._source.getLastModified());
            out.write(result.getBytes(StandardCharsets.UTF_8));
        }
    }
}

