/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.ametys.runtime.model.AbstractModelItem;
import org.ametys.runtime.model.DefinitionContext;
import org.ametys.runtime.model.ModelItem;
import org.ametys.runtime.model.disableconditions.DisableCondition;
import org.ametys.runtime.model.disableconditions.DisableConditions;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.commons.lang3.StringUtils;

public class ModelItemHelper
implements Component,
Serviceable,
Contextualizable {
    public static final String ROLE = ModelItemHelper.class.getName();

    public void contextualize(Context context) throws ContextException {
        AbstractModelItem.setContext(context);
    }

    public void service(ServiceManager manager) throws ServiceException {
        AbstractModelItem.setServiceManager(manager);
    }

    public Map<String, Object> disableConditionsToJSON(ModelItem modelItem, DefinitionContext context) {
        DisableConditions<? extends DisableCondition> disableConditions = modelItem.getDisableConditions();
        return this._disableConditionsToJSON(modelItem, disableConditions, context);
    }

    private Map<String, Object> _disableConditionsToJSON(ModelItem modelItem, DisableConditions<? extends DisableCondition> disableConditions, DefinitionContext context) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<Map<String, String>> disableConditionList = new ArrayList<Map<String, String>>();
        map.put("condition", disableConditionList);
        for (DisableCondition disableCondition : disableConditions.getConditions()) {
            Map<String, String> disableConditionAsMap = disableCondition.isExternal(context) ? this.externalDisableConditionToJSON(modelItem, disableCondition) : this.disableConditionToJSON(disableCondition);
            disableConditionList.add(disableConditionAsMap);
        }
        ArrayList<Map<String, Object>> disableConditionsList = new ArrayList<Map<String, Object>>();
        map.put("conditions", disableConditionsList);
        for (DisableConditions<? extends DisableCondition> subDisableConditions : disableConditions.getSubConditions()) {
            Map<String, Object> disableConditionsAsMap = this._disableConditionsToJSON(modelItem, subDisableConditions, context);
            disableConditionsList.add(disableConditionsAsMap);
        }
        map.put("type", disableConditions.getAssociationType().toString().toLowerCase());
        return map;
    }

    public Map<String, String> externalDisableConditionToJSON(ModelItem modelItem, DisableCondition disableCondition) {
        HashMap<String, String> map = new HashMap<String, String>();
        String id = StringUtils.join((Object[])new String[]{"__external", disableCondition.getId(), disableCondition.getName()}, (String)"_");
        map.put("id", id);
        map.put("operator", DisableCondition.OPERATOR.EQ.toString().toLowerCase());
        map.put("value", String.valueOf(Boolean.TRUE));
        return map;
    }

    public Map<String, String> disableConditionToJSON(DisableCondition disableCondition) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("id", disableCondition.getName());
        map.put("operator", disableCondition.getOperator().toString().toLowerCase());
        map.put("value", disableCondition.getValue());
        return map;
    }
}

