/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import javax.xml.transform.TransformerException;
import org.ametys.core.model.type.AbstractModelItemType;
import org.ametys.core.model.type.ModelItemTypeHelper;
import org.ametys.core.util.JSONUtils;
import org.ametys.core.util.dom.DOMUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.ElementDefinition;
import org.ametys.runtime.model.Enumerator;
import org.ametys.runtime.model.compare.DataChangeType;
import org.ametys.runtime.model.compare.DataChangeTypeDetail;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.ametys.runtime.model.type.ElementType;
import org.ametys.runtime.util.ParameterizedTypesHelper;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.ConfigurationUtil;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractElementType<T>
extends AbstractModelItemType
implements ElementType<T>,
Component,
Serviceable {
    protected static final String ENUMERATED_DATA_VALUE_KEY = "value";
    protected static final String ENUMERATED_DATA_LABEL_KEY = "label";
    protected static final String TYPE_ID_KEY = "typeId";
    protected static final String CARDINALITY_KEY = "multiple";
    protected static final String SAX_AS_JSON_KEY = "json";
    protected JSONUtils _jsonUtils;
    private Class<T> _type = ParameterizedTypesHelper.getFirstActualClassArgument(AbstractElementType.class, this.getClass());
    private Class<T[]> _typeArray = this._type.arrayType();

    public void service(ServiceManager manager) throws ServiceException {
        if (manager.hasService(JSONUtils.ROLE)) {
            this._jsonUtils = (JSONUtils)manager.lookup(JSONUtils.ROLE);
        }
    }

    @Override
    public String toString(T value) {
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    @Override
    public Object fromJSONForClient(Object json, DataContext context) throws BadItemTypeException {
        if (json == null) {
            return null;
        }
        if (json instanceof List) {
            List jsonList = (List)json;
            Object arrayValue = Array.newInstance(this.getManagedClass(), jsonList.size());
            for (int i = 0; i < jsonList.size(); ++i) {
                Object singleJSONValue = jsonList.get(i);
                Object singleValue = this.fromJSONForClient(singleJSONValue, context);
                Array.set(arrayValue, i, singleValue);
            }
            return arrayValue;
        }
        if (this._isEnumeratedJSONObject(json)) {
            Object value = ((Map)json).get(ENUMERATED_DATA_VALUE_KEY);
            return this._singleValueFromJSON(value, context);
        }
        return this._singleValueFromJSON(json, context);
    }

    protected boolean _isEnumeratedJSONObject(Object json) {
        Map jsonMap;
        return json instanceof Map && (jsonMap = (Map)json).size() == 2 && jsonMap.containsKey(ENUMERATED_DATA_VALUE_KEY) && jsonMap.containsKey(ENUMERATED_DATA_LABEL_KEY);
    }

    protected T _singleValueFromJSON(Object json, DataContext context) throws BadItemTypeException {
        return this.castValue(json);
    }

    @Override
    public Object valueToJSONForClient(Object value, DataContext context) throws BadItemTypeException {
        return this._valueToJSON(value, context, this::_singleValueToJSON);
    }

    @Override
    public Object valueToJSONForEdition(Object value, DataContext context) throws BadItemTypeException {
        return this._valueToJSON(value, context, this::_singleValueToJSONForEdition);
    }

    protected Object _valueToJSON(Object value, DataContext context, BiFunction<Object, DataContext, Object> singleValueToJSONFunction) throws BadItemTypeException {
        if (value == null) {
            return null;
        }
        if (value.getClass().isArray()) {
            return Stream.of((Object[])value).filter(Objects::nonNull).map(v -> this._singleValueToJSON(v, context, singleValueToJSONFunction)).filter(Objects::nonNull).toList();
        }
        return this._singleValueToJSON(value, context, singleValueToJSONFunction);
    }

    protected Object _singleValueToJSON(Object value, DataContext context, BiFunction<Object, DataContext, Object> singleValueToJSONFunction) throws BadItemTypeException {
        Object jsonValue = singleValueToJSONFunction.apply(value, context);
        Optional<Enumerator> optionalEnumerator = context.getModelItem().filter(ElementDefinition.class::isInstance).map(ElementDefinition.class::cast).map(ElementDefinition::getEnumerator);
        if (optionalEnumerator.isPresent()) {
            Enumerator enumerator = optionalEnumerator.get();
            I18nizableText i18n = null;
            try {
                i18n = enumerator.getEntry(value);
            }
            catch (Exception e) {
                this.getLogger().warn("JSON conversion for data '" + context.getFullDataPath() + "' requires a label for enumerated value", (Throwable)e);
            }
            if (i18n != null) {
                return Map.of(ENUMERATED_DATA_VALUE_KEY, jsonValue, ENUMERATED_DATA_LABEL_KEY, i18n);
            }
            return jsonValue;
        }
        return jsonValue;
    }

    protected Object _singleValueToJSON(Object value, DataContext context) throws BadItemTypeException {
        if (this.getManagedClass().isInstance(value)) {
            return this._singleTypedValueToJSON(this.getManagedClass().cast(value), context);
        }
        throw new BadItemTypeException("Try to convert the non " + this.getId() + " JSON object '" + String.valueOf(value) + "' into a " + this.getManagedClass().getName());
    }

    protected Object _singleTypedValueToJSON(T value, DataContext context) {
        return value;
    }

    protected Object _singleValueToJSONForEdition(Object value, DataContext context) throws BadItemTypeException {
        if (this.getManagedClass().isInstance(value)) {
            return this._singleTypedValueToJSONForEdition(this.getManagedClass().cast(value), context);
        }
        throw new BadItemTypeException("Try to convert the non " + this.getId() + " JSON object '" + String.valueOf(value) + "' into a " + this.getManagedClass().getName());
    }

    protected Object _singleTypedValueToJSONForEdition(T value, DataContext context) {
        return this._singleTypedValueToJSON(value, context);
    }

    @Override
    public T parseConfiguration(Configuration configuration) throws ConfigurationException {
        Element element = ConfigurationUtil.toElement((Configuration)configuration);
        try {
            return this._singleValueFromXML(element, Optional.empty());
        }
        catch (Exception e) {
            throw new ConfigurationException("An error occurs while parsing configuration of an I/O data", (Throwable)e);
        }
    }

    @Override
    public Object valueFromXML(Element parent, String name, Optional<Object> additionalData) {
        if (parent != null) {
            List<Element> children = DOMUtils.getChildElementsByTagName(parent, name);
            ArrayList<T> values = new ArrayList<T>();
            boolean isMultiple = false;
            for (Element element : children) {
                try {
                    T singleValue = this._singleValueFromXML(element, additionalData);
                    if (!this.isSingleValueEmpty(singleValue)) {
                        values.add(singleValue);
                    }
                    isMultiple = this._isValueFromXMLMultiple(element);
                }
                catch (TransformerException e) {
                    throw new IllegalArgumentException("Unable to parse DOM element to get the value", e);
                }
            }
            if (values.isEmpty()) {
                return null;
            }
            if (isMultiple) {
                Object[] array = (Object[])Array.newInstance(this.getManagedClass(), values.size());
                return values.toArray(array);
            }
            return values.get(0);
        }
        return null;
    }

    protected boolean _isValueFromXMLMultiple(Element element) throws TransformerException {
        return Boolean.valueOf(element.getAttribute(CARDINALITY_KEY));
    }

    protected T _singleValueFromXML(Element element, Optional<Object> additionalData) {
        String value = Optional.ofNullable(element.getAttribute(ENUMERATED_DATA_VALUE_KEY)).filter(StringUtils::isNotEmpty).orElseGet(element::getTextContent);
        return this.castValue(value);
    }

    protected boolean isSingleValueEmpty(T value) {
        return value == null;
    }

    @Override
    public void valueToSAXForEdition(ContentHandler contentHandler, String tagName, Object value, DataContext context) throws SAXException, BadItemTypeException {
        this._valueToSAX(contentHandler, tagName, value, context, true);
    }

    @Override
    public void valueToSAX(ContentHandler contentHandler, String tagName, Object value, DataContext context) throws SAXException, BadItemTypeException {
        this._valueToSAX(contentHandler, tagName, value, context, false);
    }

    protected void _valueToSAX(ContentHandler contentHandler, String tagName, Object value, DataContext context, boolean isEdition) throws SAXException, BadItemTypeException {
        AttributesImpl attributes = this._getValueAttributes(value, context, isEdition);
        if (value == null) {
            XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attributes);
        } else if (isEdition) {
            this._valueToSAXForEdition(contentHandler, tagName, value, context, attributes);
        } else {
            this._valueToSAX(contentHandler, tagName, value, context, attributes);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void _valueToSAXForEdition(ContentHandler contentHandler, String tagName, Object value, DataContext context, AttributesImpl attributes) throws SAXException, BadItemTypeException {
        if (this._useJSONForEdition()) {
            if (this._jsonUtils == null) throw new IllegalStateException("Unable to generate SAX events in tag name '" + tagName + "'. The component '" + JSONUtils.ROLE + "' has not been initialized");
            Object valueAsJSON = this.valueToJSONForClient(value, context);
            String jsonString = this._jsonUtils.convertObjectToJson(valueAsJSON);
            XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attributes, (String)jsonString);
            return;
        } else {
            this._valueToSAX(contentHandler, tagName, value, context, attributes);
        }
    }

    protected void _valueToSAX(ContentHandler contentHandler, String tagName, Object value, DataContext context, AttributesImpl attributes) throws SAXException, BadItemTypeException {
        if (value.getClass().isArray()) {
            if (Array.getLength(value) <= 0) {
                XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attributes);
            } else {
                for (Object singleValue : (Object[])value) {
                    if (singleValue == null) continue;
                    this._singleValueToSAX(contentHandler, tagName, singleValue, context, attributes);
                }
            }
        } else {
            this._singleValueToSAX(contentHandler, tagName, value, context, attributes);
        }
    }

    protected void _singleValueToSAX(ContentHandler contentHandler, String tagName, Object value, DataContext context, AttributesImpl attributes) throws SAXException, BadItemTypeException {
        AttributesImpl localAttributes = new AttributesImpl((Attributes)attributes);
        Optional<Enumerator> optionalEnumerator = context.getModelItem().filter(ElementDefinition.class::isInstance).map(ElementDefinition.class::cast).map(ElementDefinition::getEnumerator);
        if (optionalEnumerator.isPresent()) {
            Enumerator enumerator = optionalEnumerator.get();
            I18nizableText i18n = null;
            try {
                i18n = enumerator.getEntry(value);
            }
            catch (Exception e) {
                this.getLogger().warn("SAX events generated at tag '" + tagName + "' requires a label for enumerated value", (Throwable)e);
            }
            if (i18n != null) {
                this._singleEnumeratedValueToSAX(contentHandler, tagName, value, i18n, context, localAttributes);
            } else {
                this._singleNotEnumeratedValueToSAX(contentHandler, tagName, value, context, localAttributes);
            }
        } else {
            this._singleNotEnumeratedValueToSAX(contentHandler, tagName, value, context, localAttributes);
        }
    }

    protected void _singleNotEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, Object value, DataContext context, AttributesImpl attributes) throws SAXException, BadItemTypeException {
        if (!this.getManagedClass().isInstance(value)) {
            throw new BadItemTypeException("Try to sax the non compatible value '" + String.valueOf(value) + "' in tag name '" + tagName + "' with the type '" + this.getId() + "'");
        }
        this._singleTypedNotEnumeratedValueToSAX(contentHandler, tagName, this.getManagedClass().cast(value), context, attributes);
    }

    protected void _singleTypedNotEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, T value, DataContext context, AttributesImpl attributes) throws SAXException {
        XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)attributes, (String)this.toString(value));
    }

    protected void _singleEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, Object value, I18nizableText i18n, DataContext context, AttributesImpl attributes) throws SAXException, BadItemTypeException {
        if (!this.getManagedClass().isInstance(value)) {
            throw new BadItemTypeException("Try to sax the non compatible value '" + String.valueOf(value) + "' in tag name '" + tagName + "' with the type '" + this.getId() + "'");
        }
        this._singleTypedEnumeratedValueToSAX(contentHandler, tagName, this.getManagedClass().cast(value), i18n, context, attributes);
    }

    protected void _singleTypedEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, T value, I18nizableText i18n, DataContext context, AttributesImpl attributes) throws SAXException {
        AttributesImpl localAttributes = new AttributesImpl((Attributes)attributes);
        localAttributes.addCDATAAttribute(ENUMERATED_DATA_VALUE_KEY, this.toString(value));
        XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)localAttributes);
        i18n.toSAX(contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
    }

    protected AttributesImpl _getValueAttributes(Object value, DataContext context, boolean isEdition) {
        AttributesImpl attributes = ModelItemTypeHelper.getXMLAttributesFromDataContext(context);
        attributes.addCDATAAttribute(TYPE_ID_KEY, this.getId());
        boolean isMultiple = value != null && value.getClass().isArray();
        attributes.addCDATAAttribute(CARDINALITY_KEY, String.valueOf(isMultiple));
        if (isEdition && this._useJSONForEdition()) {
            attributes.addCDATAAttribute(SAX_AS_JSON_KEY, "true");
        }
        return attributes;
    }

    protected boolean _useJSONForEdition() {
        return false;
    }

    @Override
    public Object parseDefaultValue(Configuration configuration) throws ConfigurationException {
        return this.parseConfiguration(configuration);
    }

    @Override
    public Stream<Triple<DataChangeType, DataChangeTypeDetail, String>> compareValues(Object value1, Object value2) {
        if (this._isMultiple(value1) && this._isMultiple(value2)) {
            T[] value1Array = this._castMultipleValue(value1);
            T[] value2Array = this._castMultipleValue(value2);
            return this._compareMultipleValues(value1Array, value2Array);
        }
        if (this._isSingle(value1) && this._isSingle(value2)) {
            T typedValue1 = this.castValue(value1);
            T typedValue2 = this.castValue(value2);
            return this._compareSingleValues(typedValue1, typedValue2);
        }
        return Stream.of(new ImmutableTriple((Object)DataChangeType.MODIFIED, (Object)DataChangeTypeDetail.NONE, (Object)""));
    }

    protected boolean _isMultiple(Object value) {
        return this.getManagedClassArray().isInstance(value);
    }

    protected boolean _isSingle(Object value) {
        return value == null || this.getManagedClass().isInstance(value);
    }

    private T[] _castMultipleValue(Object value) throws BadItemTypeException {
        ArrayList<T> valuesAsList = new ArrayList<T>();
        for (int i = 0; i < Array.getLength(value); ++i) {
            T singleValue = this.castValue(Array.get(value, i));
            valuesAsList.add(singleValue);
        }
        return valuesAsList.toArray((Object[])Array.newInstance(this.getManagedClass(), valuesAsList.size()));
    }

    protected Stream<Triple<DataChangeType, DataChangeTypeDetail, String>> _compareMultipleValues(T[] value1, T[] value2) {
        if (!Arrays.deepEquals(value1, value2)) {
            DataChangeType type = DataChangeType.MODIFIED;
            DataChangeTypeDetail detail = DataChangeTypeDetail.NONE;
            if (value1.length == value2.length) {
                T[] diff = this._removeAllOnce(value1, value2);
                if (diff.length == 0) {
                    detail = DataChangeTypeDetail.ORDER;
                }
            } else if (this._containsAll(value2, value1)) {
                detail = DataChangeTypeDetail.MORE;
            } else if (this._containsAll(value1, value2)) {
                detail = DataChangeTypeDetail.LESS;
            }
            return Stream.of(new ImmutableTriple((Object)type, (Object)detail, (Object)""));
        }
        return Stream.empty();
    }

    protected Stream<Triple<DataChangeType, DataChangeTypeDetail, String>> _compareSingleValues(T value1, T value2) {
        return ModelItemTypeHelper.compareSingleObjects(value1, value2, "").stream();
    }

    private T[] _removeAllOnce(T[] list1, T[] list2) {
        Object[] result = (Object[])list1.clone();
        for (T element : list2) {
            result = ArrayUtils.removeElement((Object[])result, element);
        }
        return result;
    }

    private boolean _containsAll(T[] list1, T[] list2) {
        Object[] listClone = (Object[])list1.clone();
        for (T element : list2) {
            if (!ArrayUtils.contains((Object[])listClone, element)) {
                return false;
            }
            listClone = ArrayUtils.removeElement((Object[])listClone, element);
        }
        return true;
    }

    @Override
    public boolean isCompatible(Object value) {
        return value != null ? this.getManagedClass().isInstance(value) || this.getManagedClassArray().isInstance(value) : false;
    }

    @Override
    public T castValue(Object value) throws BadItemTypeException {
        if (value == null) {
            return null;
        }
        if (this.getManagedClass().isInstance(value)) {
            return this.getManagedClass().cast(value);
        }
        return this.convertValue(value);
    }

    protected T convertValue(Object value) throws BadItemTypeException {
        throw new BadItemTypeException("Unable to convert the given value '" + String.valueOf(value) + "'. This value is not compatible with the type '" + this.getId() + "'");
    }

    @Override
    public Class<T> getManagedClass() {
        return this._type;
    }

    @Override
    public Class<T[]> getManagedClassArray() {
        return this._typeArray;
    }
}

