/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.stream.Stream;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.core.model.type.ModelItemTypeHelper;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.i18n.I18nizableText;
import org.ametys.runtime.model.compare.DataChangeType;
import org.ametys.runtime.model.compare.DataChangeTypeDetail;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class BaseDateElementType
extends AbstractElementType<LocalDate> {
    protected static final String DATE_VALUE_KEY = "date-value";
    private static final String __ISO_DATE_PATTERN_WITH_OPTIONAL_TIME = "uuuu-MM-dd['T'HH:mm:ss[.SSS]XXX]";

    @Override
    public LocalDate convertValue(Object value) throws BadItemTypeException {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (StringUtils.isEmpty((CharSequence)stringValue)) {
                return null;
            }
            try {
                return DateUtils.parseLocalDate(stringValue, __ISO_DATE_PATTERN_WITH_OPTIONAL_TIME);
            }
            catch (DateTimeParseException e) {
                throw new BadItemTypeException("Unable to cast '" + String.valueOf(value) + "' to a date", e);
            }
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime zdtValue = (ZonedDateTime)value;
            return zdtValue.toLocalDate();
        }
        if (value instanceof Date) {
            Date dateValue = (Date)value;
            return DateUtils.asLocalDate(dateValue);
        }
        if (value instanceof Instant) {
            Instant instantValue = (Instant)value;
            return DateUtils.asLocalDate(instantValue);
        }
        return (LocalDate)super.convertValue(value);
    }

    @Override
    public String toString(LocalDate value) {
        if (value == null) {
            return null;
        }
        return DateUtils.localDateToString(value);
    }

    @Override
    protected Object _singleTypedValueToJSON(LocalDate value, DataContext context) {
        return this.toString(value);
    }

    @Override
    protected void _singleTypedNotEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, LocalDate value, DataContext context, AttributesImpl attributes) throws SAXException {
        AttributesImpl localAttributes = new AttributesImpl((Attributes)attributes);
        localAttributes.addCDATAAttribute(DATE_VALUE_KEY, this.toString(value));
        ZonedDateTime zdt = value.atStartOfDay(ZoneId.systemDefault());
        String valueAsString = DateUtils.zonedDateTimeToString(zdt);
        XMLUtils.createElement((ContentHandler)contentHandler, (String)tagName, (Attributes)localAttributes, (String)valueAsString);
    }

    @Override
    protected void _singleTypedEnumeratedValueToSAX(ContentHandler contentHandler, String tagName, LocalDate value, I18nizableText i18n, DataContext context, AttributesImpl attributes) throws SAXException {
        AttributesImpl localAttributes = new AttributesImpl((Attributes)attributes);
        localAttributes.addCDATAAttribute(DATE_VALUE_KEY, this.toString(value));
        ZonedDateTime zdt = value.atStartOfDay(ZoneId.systemDefault());
        String valueAsString = DateUtils.zonedDateTimeToString(zdt);
        localAttributes.addCDATAAttribute("value", valueAsString);
        XMLUtils.startElement((ContentHandler)contentHandler, (String)tagName, (Attributes)localAttributes);
        i18n.toSAX(contentHandler);
        XMLUtils.endElement((ContentHandler)contentHandler, (String)tagName);
    }

    @Override
    protected Stream<Triple<DataChangeType, DataChangeTypeDetail, String>> _compareSingleValues(LocalDate value1, LocalDate value2) {
        return ModelItemTypeHelper.compareSingleDates(value1, value2, "").stream();
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

