/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.stream.Stream;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.core.model.type.ModelItemTypeHelper;
import org.ametys.core.util.DateUtils;
import org.ametys.runtime.model.compare.DataChangeType;
import org.ametys.runtime.model.compare.DataChangeTypeDetail;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.ametys.runtime.model.type.DataContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class BaseDateTimeElementType
extends AbstractElementType<ZonedDateTime> {
    private static final String __ISO_DATETIME_PATTERN_WITH_OPTIONAL_SECOND_FRACTION_AND_OFFSET = "uuuu-MM-dd'T'HH:mm:ss[.SSS]XXX";

    @Override
    public ZonedDateTime convertValue(Object value) throws BadItemTypeException {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (StringUtils.isEmpty((CharSequence)stringValue)) {
                return null;
            }
            try {
                return DateUtils.parseZonedDateTime(stringValue, __ISO_DATETIME_PATTERN_WITH_OPTIONAL_SECOND_FRACTION_AND_OFFSET);
            }
            catch (DateTimeParseException e) {
                throw new BadItemTypeException("Unable to cast '" + String.valueOf(value) + "' to a date", e);
            }
        }
        if (value instanceof Date) {
            Date dateValue = (Date)value;
            return DateUtils.asZonedDateTime(dateValue);
        }
        if (value instanceof Instant) {
            Instant instantValue = (Instant)value;
            return DateUtils.asZonedDateTime(instantValue);
        }
        return (ZonedDateTime)super.convertValue(value);
    }

    @Override
    public String toString(ZonedDateTime value) {
        if (value == null) {
            return null;
        }
        return DateUtils.zonedDateTimeToString(value);
    }

    @Override
    protected Object _singleTypedValueToJSON(ZonedDateTime value, DataContext context) {
        return this.toString(value);
    }

    @Override
    protected Stream<Triple<DataChangeType, DataChangeTypeDetail, String>> _compareSingleValues(ZonedDateTime value1, ZonedDateTime value2) {
        return ModelItemTypeHelper.compareSingleDates(value1, value2, "").stream();
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

