/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.stream.Stream;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.core.model.type.ModelItemTypeHelper;
import org.ametys.runtime.model.compare.DataChangeType;
import org.ametys.runtime.model.compare.DataChangeTypeDetail;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class BaseDoubleElementType
extends AbstractElementType<Double> {
    private static final ThreadLocal<DecimalFormat> __FORMATTER = new ThreadLocal();

    @Override
    public Double convertValue(Object value) throws BadItemTypeException {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            if (StringUtils.isEmpty((CharSequence)((String)value))) {
                return null;
            }
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadItemTypeException("Unable to cast '" + String.valueOf(value) + "' to a double", e);
            }
        }
        return (Double)super.convertValue(value);
    }

    @Override
    protected Stream<Triple<DataChangeType, DataChangeTypeDetail, String>> _compareSingleValues(Double value1, Double value2) {
        return ModelItemTypeHelper.compareSingleNumbers(value1, value2, "").stream();
    }

    @Override
    public boolean isCompatible(Object value) {
        return super.isCompatible(value) || value instanceof double[] || value instanceof Float || value instanceof Float[] || value instanceof float[];
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public String toString(Double value) {
        if (value == null) {
            return null;
        }
        DecimalFormat df = __FORMATTER.get();
        if (df == null) {
            df = new DecimalFormat("0.0", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
            df.setMaximumFractionDigits(340);
            __FORMATTER.set(df);
        }
        return df.format(value);
    }
}

