/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.util.stream.Stream;
import org.ametys.core.model.type.AbstractElementType;
import org.ametys.core.model.type.ModelItemTypeHelper;
import org.ametys.runtime.model.compare.DataChangeType;
import org.ametys.runtime.model.compare.DataChangeTypeDetail;
import org.ametys.runtime.model.exception.BadItemTypeException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Triple;

public class BaseLongElementType
extends AbstractElementType<Long> {
    @Override
    public Long convertValue(Object value) throws BadItemTypeException {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            if (StringUtils.isEmpty((CharSequence)((String)value))) {
                return null;
            }
            try {
                return Long.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new BadItemTypeException("Unable to cast '" + String.valueOf(value) + "' to a long", e);
            }
        }
        return (Long)super.convertValue(value);
    }

    @Override
    protected Stream<Triple<DataChangeType, DataChangeTypeDetail, String>> _compareSingleValues(Long value1, Long value2) {
        return ModelItemTypeHelper.compareSingleNumbers(value1, value2, "").stream();
    }

    @Override
    public boolean isCompatible(Object value) {
        return super.isCompatible(value) || value instanceof long[] || value instanceof Integer || value instanceof Integer[] || value instanceof int[];
    }

    @Override
    public boolean isSimple() {
        return true;
    }
}

