/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.model.type;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.ametys.runtime.model.ModelHelper;
import org.ametys.runtime.model.compare.DataChangeType;
import org.ametys.runtime.model.compare.DataChangeTypeDetail;
import org.ametys.runtime.model.type.DataContext;
import org.apache.cocoon.xml.AttributesImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public final class ModelItemTypeHelper {
    private ModelItemTypeHelper() {
    }

    public static Optional<Triple<DataChangeType, DataChangeTypeDetail, String>> compareSingleStrings(String string1, String string2, String dataName) {
        if (StringUtils.isNotEmpty((CharSequence)string1) && StringUtils.isNotEmpty((CharSequence)string2)) {
            if (!string1.equals(string2)) {
                DataChangeTypeDetail detail = DataChangeTypeDetail.NONE;
                if (string1.startsWith(string2)) {
                    detail = DataChangeTypeDetail.LESS_CONTENT_END;
                } else if (string2.startsWith(string1)) {
                    detail = DataChangeTypeDetail.MORE_CONTENT_END;
                } else if (string1.endsWith(string2)) {
                    detail = DataChangeTypeDetail.LESS_CONTENT_START;
                } else if (string2.endsWith(string1)) {
                    detail = DataChangeTypeDetail.MORE_CONTENT_START;
                } else if (string1.contains(string2)) {
                    detail = DataChangeTypeDetail.LESS_CONTENT;
                } else if (string2.contains(string1)) {
                    detail = DataChangeTypeDetail.MORE_CONTENT;
                }
                return Optional.of(new ImmutableTriple((Object)DataChangeType.MODIFIED, (Object)detail, (Object)dataName));
            }
            return Optional.empty();
        }
        if (StringUtils.isNotEmpty((CharSequence)string1) && StringUtils.isEmpty((CharSequence)string2)) {
            return Optional.of(new ImmutableTriple((Object)DataChangeType.REMOVED, (Object)DataChangeTypeDetail.NONE, (Object)dataName));
        }
        if (StringUtils.isEmpty((CharSequence)string1) && StringUtils.isNotEmpty((CharSequence)string2)) {
            return Optional.of(new ImmutableTriple((Object)DataChangeType.ADDED, (Object)DataChangeTypeDetail.NONE, (Object)dataName));
        }
        return Optional.empty();
    }

    public static Optional<Triple<DataChangeType, DataChangeTypeDetail, String>> compareSingleObjects(Object object1, Object object2, String dataName) {
        if (object1 != null && object2 == null) {
            return Optional.of(new ImmutableTriple((Object)DataChangeType.REMOVED, (Object)DataChangeTypeDetail.NONE, (Object)dataName));
        }
        if (object1 == null && object2 != null) {
            return Optional.of(new ImmutableTriple((Object)DataChangeType.ADDED, (Object)DataChangeTypeDetail.NONE, (Object)dataName));
        }
        if (object1 == null || object1.equals(object2)) {
            return Optional.empty();
        }
        return Optional.of(new ImmutableTriple((Object)DataChangeType.MODIFIED, (Object)DataChangeTypeDetail.NONE, (Object)dataName));
    }

    public static Optional<Triple<DataChangeType, DataChangeTypeDetail, String>> compareSingleNumbers(Number number1, Number number2, String dataName) {
        if (ModelItemTypeHelper.areSingleObjectsBothNotNullAndDifferents(number1, number2)) {
            DataChangeTypeDetail detail = DataChangeTypeDetail.LESS;
            if (number2.doubleValue() > number1.doubleValue()) {
                detail = DataChangeTypeDetail.MORE;
            }
            return Optional.of(new ImmutableTriple((Object)DataChangeType.MODIFIED, (Object)detail, (Object)dataName));
        }
        return ModelItemTypeHelper.compareSingleObjects(number1, number2, dataName);
    }

    public static Optional<Triple<DataChangeType, DataChangeTypeDetail, String>> compareSingleDates(LocalDate date1, LocalDate date2, String dataName) {
        ZonedDateTime zdt1 = date1 != null ? date1.atStartOfDay(ZoneId.systemDefault()) : null;
        ZonedDateTime zdt2 = date2 != null ? date2.atStartOfDay(ZoneId.systemDefault()) : null;
        return ModelItemTypeHelper.compareSingleDates(zdt1, zdt2, dataName);
    }

    public static Optional<Triple<DataChangeType, DataChangeTypeDetail, String>> compareSingleDates(ZonedDateTime date1, ZonedDateTime date2, String dataName) {
        Instant instant2;
        Instant instant1 = date1 != null ? date1.toInstant() : null;
        Instant instant = instant2 = date2 != null ? date2.toInstant() : null;
        if (ModelItemTypeHelper.areSingleObjectsBothNotNullAndDifferents(instant1, instant2)) {
            DataChangeTypeDetail detail = DataChangeTypeDetail.AFTER;
            if (instant2 != null && instant2.isBefore(instant1)) {
                detail = DataChangeTypeDetail.BEFORE;
            }
            return Optional.of(new ImmutableTriple((Object)DataChangeType.MODIFIED, (Object)detail, (Object)dataName));
        }
        return ModelItemTypeHelper.compareSingleObjects(instant1, instant2, dataName);
    }

    public static boolean areSingleObjectsBothNotNullAndDifferents(Object object1, Object object2) {
        return object1 != null && object2 != null && !object1.equals(object2);
    }

    public static AttributesImpl getXMLAttributesFromDataContext(DataContext context) {
        return ModelItemTypeHelper.getXMLAttributesFromDataContext(context, true);
    }

    public static AttributesImpl getXMLAttributesFromDataContext(DataContext context, boolean renderModelInformation) {
        AttributesImpl attributes = new AttributesImpl();
        String dataPath = context.getDataPath();
        attributes.addCDATAAttribute("dataPath", dataPath);
        String fullDataPath = context.getFullDataPath();
        attributes.addCDATAAttribute("fullDataPath", fullDataPath);
        if (renderModelInformation) {
            attributes.addCDATAAttribute("modelPath", ModelHelper.getDefinitionPathFromDataPath(dataPath));
            attributes.addCDATAAttribute("fullModelPath", ModelHelper.getDefinitionPathFromDataPath(fullDataPath));
        }
        return attributes;
    }
}

