/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.observation;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.ametys.core.user.UserIdentity;

public class Event {
    private UserIdentity _issuer;
    private String _id;
    private Map<String, Object> _args;

    public Event(String eventId, UserIdentity issuer, Map<String, Object> args) {
        this._issuer = issuer;
        this._id = eventId;
        this._args = args;
    }

    public UserIdentity getIssuer() {
        return this._issuer;
    }

    public String getId() {
        return this._id;
    }

    public Map<String, Object> getArguments() {
        return this._args;
    }

    public String toString() {
        StringBuilder event = new StringBuilder();
        event.append("event[id: ");
        event.append(this._id);
        event.append(", issuer: ");
        event.append(this._issuer);
        event.append(", args: [");
        Iterator<String> it = this._args.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            event.append(key);
            event.append(" = ");
            event.append(Objects.toString(this._args.get(key)));
            if (!it.hasNext()) continue;
            event.append(", ");
        }
        event.append("]]");
        return event.toString();
    }
}

