/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.observation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.ametys.core.authentication.AuthenticateAction;
import org.ametys.core.engine.BackgroundEngineHelper;
import org.ametys.core.engine.BackgroundEnvironment;
import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.core.observation.ObserverExtensionPoint;
import org.ametys.core.user.UserIdentity;
import org.ametys.core.user.population.UserPopulationDAO;
import org.ametys.plugins.core.user.UserDAO;
import org.ametys.runtime.plugin.component.Prioritizable;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservationManager
extends AbstractLogEnabled
implements Component,
Serviceable,
Contextualizable,
Disposable {
    public static final String ROLE = ObservationManager.class.getName();
    private static final String __CURRENT_FUTURES_REQUEST_ATTR_NAME = ObservationManager.class.getName() + "$currentFutures";
    private static final String __ADDITIONAL_ARGS_TO_PASS_BY_EVENT_ID_REQUEST_ATTR_NAME = ObservationManager.class.getName() + "$.additional.args";
    private static final Logger __ALL_EVENTS_LOGGER = LoggerFactory.getLogger((String)"org.ametys.cms.observation.AllEvents");
    private static final Comparator<Observer> __OBSERVER_COMPARATOR = Comparator.comparing(Prioritizable::getPriority);
    private static ExecutorService __SINGLE_THREAD_EXECUTOR;
    private static ExecutorService __PARALLEL_THREAD_EXECUTOR;
    protected Context _context;
    protected ServiceManager _manager;
    private org.apache.avalon.framework.context.Context _avalonContext;
    private ObserverExtensionPoint _observerExtPt;
    private Collection<Observer> _registeredObservers = new ArrayList<Observer>();

    public void service(ServiceManager manager) throws ServiceException {
        this._manager = manager;
        this._observerExtPt = (ObserverExtensionPoint)manager.lookup(ObserverExtensionPoint.ROLE);
    }

    public void contextualize(org.apache.avalon.framework.context.Context context) throws ContextException {
        this._avalonContext = context;
        this._context = (Context)context.get((Object)"environment-context");
    }

    public List<Future> notify(Event event) {
        ArrayList<Future> result = new ArrayList<Future>();
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Receiving " + String.valueOf(event));
            }
            if (__ALL_EVENTS_LOGGER.isInfoEnabled()) {
                __ALL_EVENTS_LOGGER.info("Receiving " + String.valueOf(event));
            }
            ArrayList<Observer> supportedObservers = new ArrayList<Observer>();
            supportedObservers.addAll(this._observerExtPt.getSupportingExtensions(event));
            supportedObservers.addAll(this._registeredObservers.stream().filter(obs -> obs.supports(event)).toList());
            supportedObservers.sort(__OBSERVER_COMPARATOR);
            this._putAdditionalArgs(event);
            this._observesEvent(event, supportedObservers, result);
        }
        catch (Exception e) {
            this.getLogger().error("Unable to dispatch event: " + String.valueOf(event) + " to observers", (Throwable)e);
        }
        return result;
    }

    public List<ObserverFuture> getFuturesForRequest() {
        try {
            return Collections.unmodifiableList(this._getFuturesForRequest());
        }
        catch (CascadingRuntimeException e) {
            return List.of();
        }
    }

    private List<ObserverFuture> _getFuturesForRequest() throws CascadingRuntimeException {
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext);
        ArrayList futuresForCurrentRequest = (ArrayList)request.getAttribute(__CURRENT_FUTURES_REQUEST_ATTR_NAME);
        if (futuresForCurrentRequest == null) {
            futuresForCurrentRequest = new ArrayList();
            request.setAttribute(__CURRENT_FUTURES_REQUEST_ATTR_NAME, futuresForCurrentRequest);
        }
        return futuresForCurrentRequest;
    }

    public void addArgumentForEvents(String[] eventIds, String argName, Object argValue) {
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext);
        HashMap<String, HashMap<String, Object>> additionalArgsForEvents = (HashMap<String, HashMap<String, Object>>)request.getAttribute(__ADDITIONAL_ARGS_TO_PASS_BY_EVENT_ID_REQUEST_ATTR_NAME);
        if (additionalArgsForEvents == null) {
            additionalArgsForEvents = new HashMap<String, HashMap<String, Object>>();
            request.setAttribute(__ADDITIONAL_ARGS_TO_PASS_BY_EVENT_ID_REQUEST_ATTR_NAME, additionalArgsForEvents);
        }
        for (String eventId : eventIds) {
            HashMap<String, Object> additionalArgs = (HashMap<String, Object>)additionalArgsForEvents.get(eventId);
            if (additionalArgs == null) {
                additionalArgs = new HashMap<String, Object>();
                additionalArgsForEvents.put(eventId, additionalArgs);
            }
            additionalArgs.put(argName, argValue);
        }
    }

    public void removeArgumentForEvents(String[] eventIds, String argName) {
        String eventId;
        Map additionalArgs;
        Request request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext);
        Map additionalArgsForEvents = (Map)request.getAttribute(__ADDITIONAL_ARGS_TO_PASS_BY_EVENT_ID_REQUEST_ATTR_NAME);
        if (additionalArgsForEvents == null) {
            return;
        }
        String[] stringArray = eventIds;
        int n = stringArray.length;
        for (int i = 0; i < n && (additionalArgs = (Map)additionalArgsForEvents.get(eventId = stringArray[i])) != null; ++i) {
            additionalArgs.remove(argName);
        }
    }

    private void _putAdditionalArgs(Event event) {
        Map additionalArgs;
        Map additionalArgsForEvents;
        String eventId = event.getId();
        Request request = null;
        try {
            request = ContextHelper.getRequest((org.apache.avalon.framework.context.Context)this._avalonContext);
        }
        catch (CascadingRuntimeException cascadingRuntimeException) {
            // empty catch block
        }
        if (request != null && (additionalArgsForEvents = (Map)request.getAttribute(__ADDITIONAL_ARGS_TO_PASS_BY_EVENT_ID_REQUEST_ATTR_NAME)) != null && (additionalArgs = (Map)additionalArgsForEvents.get(eventId)) != null) {
            event.getArguments().putAll(additionalArgs);
        }
    }

    protected void _observesEvent(Event event, List<Observer> supportedObservers, List<Future> result) throws Exception {
        ArrayList<AsyncObserver> parallelizableAsyncObservers = new ArrayList<AsyncObserver>();
        ArrayList<AsyncObserver> nonParallelizableAsyncObservers = new ArrayList<AsyncObserver>();
        HashMap<String, Object> transientVars = new HashMap<String, Object>();
        for (Observer supportedObserver : supportedObservers) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Notifying observer: " + String.valueOf(supportedObserver) + " for event: " + String.valueOf(event));
            }
            if (supportedObserver instanceof AsyncObserver) {
                AsyncObserver asyncObserver = (AsyncObserver)supportedObserver;
                boolean parallelizable = asyncObserver.parallelizable();
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug(String.format("Adding %s asynchronous observer: '%s' for event '%s' to the async queue.", parallelizable ? "parallelizable" : "non-parallelizable", asyncObserver, event));
                }
                if (__ALL_EVENTS_LOGGER.isDebugEnabled()) {
                    __ALL_EVENTS_LOGGER.debug(String.format("Adding %s asynchronous observer: '%s' for event '%s' to the async queue.", parallelizable ? "parallelizable" : "non-parallelizable", asyncObserver, event));
                }
                if (parallelizable) {
                    parallelizableAsyncObservers.add(asyncObserver);
                    continue;
                }
                nonParallelizableAsyncObservers.add(asyncObserver);
                continue;
            }
            try {
                supportedObserver.observe(event, transientVars);
            }
            catch (Throwable e) {
                this.getLogger().error("The synchronous observer '" + supportedObserver.getClass().getName() + "' failed to observe " + String.valueOf(event), e);
            }
        }
        if (!parallelizableAsyncObservers.isEmpty() || !nonParallelizableAsyncObservers.isEmpty()) {
            this._asyncObserve(parallelizableAsyncObservers, nonParallelizableAsyncObservers, event, transientVars, result);
        }
    }

    private void _asyncObserve(Collection<AsyncObserver> parallelObservers, List<AsyncObserver> nonParallelObservers, Event event, Map<String, Object> transientVars, List<Future> result) {
        List<ObserverFuture> futuresForCurrentRequest = null;
        try {
            futuresForCurrentRequest = this._getFuturesForRequest();
        }
        catch (CascadingRuntimeException cascadingRuntimeException) {
            // empty catch block
        }
        if (__SINGLE_THREAD_EXECUTOR == null) {
            AsyncObserveThreadFactory threadFactory = new AsyncObserveThreadFactory();
            __SINGLE_THREAD_EXECUTOR = Executors.newSingleThreadExecutor(threadFactory);
            __PARALLEL_THREAD_EXECUTOR = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);
        }
        if (!parallelObservers.isEmpty()) {
            for (AsyncObserver observer : parallelObservers) {
                Future<Object> future = __PARALLEL_THREAD_EXECUTOR.submit(new ParallelAsyncObserve(this, observer, event, transientVars, this.getLogger(), __ALL_EVENTS_LOGGER));
                result.add(future);
                if (futuresForCurrentRequest == null) continue;
                futuresForCurrentRequest.add(new ObserverFuture(future, observer.getTraits()));
            }
        }
        if (!nonParallelObservers.isEmpty()) {
            Future<Object> future = __SINGLE_THREAD_EXECUTOR.submit(new NonParallelAsyncObserve(this, nonParallelObservers, event, transientVars, this.getLogger(), __ALL_EVENTS_LOGGER));
            result.add(future);
            if (futuresForCurrentRequest != null) {
                HashSet<String> traits = new HashSet<String>();
                for (Observer observer : nonParallelObservers) {
                    traits.addAll(observer.getTraits());
                }
                futuresForCurrentRequest.add(new ObserverFuture(future, traits));
            }
        }
    }

    public void dispose() {
        if (__SINGLE_THREAD_EXECUTOR != null) {
            __SINGLE_THREAD_EXECUTOR.shutdownNow();
            __SINGLE_THREAD_EXECUTOR = null;
        }
        if (__PARALLEL_THREAD_EXECUTOR != null) {
            __PARALLEL_THREAD_EXECUTOR.shutdownNow();
            __PARALLEL_THREAD_EXECUTOR = null;
        }
        this._context = null;
        this._manager = null;
    }

    public void registerObserver(Observer observer) {
        this._registeredObservers.add(observer);
    }

    public void unregisterObserver(Observer observer) {
        this._registeredObservers.remove(observer);
    }

    static class AsyncObserveThreadFactory
    implements ThreadFactory {
        private ThreadFactory _defaultThreadFactory = Executors.defaultThreadFactory();
        private String _nameFormat = "ametys-async-observe-%d";
        private AtomicLong _count = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this._defaultThreadFactory.newThread(r);
            thread.setName(String.format(this._nameFormat, this._count.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        }
    }

    class ParallelAsyncObserve
    extends AbstractAsyncObserve {
        private final AsyncObserver _observer;

        ParallelAsyncObserve(ObservationManager this$0, AsyncObserver observer, Event event, Map<String, Object> transientVars, org.apache.avalon.framework.logger.Logger logger, Logger allEventLogger) {
            super(event, transientVars, logger, allEventLogger);
            this._observer = observer;
        }

        @Override
        protected void _observe() throws Exception {
            if (this._logger.isDebugEnabled()) {
                this._logger.debug("Observing the asynchronous observer: " + String.valueOf(this._observer) + " for event: " + String.valueOf(this._event) + ".");
            }
            if (this._allEventLogger.isDebugEnabled()) {
                this._allEventLogger.debug("Observing the asynchronous observer: " + String.valueOf(this._observer) + " for event: " + String.valueOf(this._event) + ".");
            }
            this._observer.observe(this._event, this._transientVars);
        }
    }

    public record ObserverFuture(Future future, Set<String> traits) {
    }

    class NonParallelAsyncObserve
    extends AbstractAsyncObserve {
        private final Collection<AsyncObserver> _observers;

        NonParallelAsyncObserve(ObservationManager this$0, Collection<AsyncObserver> observers, Event event, Map<String, Object> transientVars, org.apache.avalon.framework.logger.Logger logger, Logger allEventLogger) {
            super(event, transientVars, logger, allEventLogger);
            this._observers = observers;
        }

        @Override
        protected void _observe() throws Exception {
            for (AsyncObserver observer : this._observers) {
                if (this._logger.isDebugEnabled()) {
                    this._logger.debug("Observing the asynchronous observer: " + String.valueOf(observer) + " for event: " + String.valueOf(this._event) + ".");
                }
                if (this._allEventLogger.isDebugEnabled()) {
                    this._allEventLogger.debug("Observing the asynchronous observer: " + String.valueOf(observer) + " for event: " + String.valueOf(this._event) + ".");
                }
                observer.observe(this._event, this._transientVars);
            }
        }
    }

    abstract class AbstractAsyncObserve
    implements Callable<Object> {
        protected final Event _event;
        protected final Map<String, Object> _transientVars;
        protected final org.apache.avalon.framework.logger.Logger _logger;
        protected final Logger _allEventLogger;

        AbstractAsyncObserve(Event event, Map<String, Object> transientVars, org.apache.avalon.framework.logger.Logger logger, Logger allEventLogger) {
            this._event = event;
            this._transientVars = transientVars;
            this._logger = logger;
            this._allEventLogger = allEventLogger;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            Map<String, Object> environmentInformation = null;
            Integer computedResult = 0;
            try {
                environmentInformation = BackgroundEngineHelper.createAndEnterEngineEnvironment(ObservationManager.this._manager, ObservationManager.this._context, this._logger);
                this._setUserInSession(environmentInformation);
                this._observe();
            }
            catch (Exception e) {
                this._logger.error("Unable to dispatch event: " + String.valueOf(this._event) + " to asynchronous observers", (Throwable)e);
                computedResult = -1;
            }
            finally {
                BackgroundEngineHelper.leaveEngineEnvironment(environmentInformation);
            }
            return computedResult;
        }

        private boolean _setUserInSession(Map<String, Object> environmentInformation) {
            UserIdentity userIdentity = Optional.ofNullable(this._event.getIssuer()).orElse(UserPopulationDAO.SYSTEM_USER_IDENTITY);
            BackgroundEnvironment bgEnv = (BackgroundEnvironment)((Object)environmentInformation.get("environment"));
            Request request = ObjectModelHelper.getRequest((Map)bgEnv.getObjectModel());
            AuthenticateAction.setUserIdentityInSession(request, userIdentity, new UserDAO.ImpersonateCredentialProvider(), true);
            return true;
        }

        protected abstract void _observe() throws Exception;
    }
}

