/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.util.HashSet;
import java.util.Set;
import org.ametys.core.resources.AbstractResourceHandlerProvider;
import org.ametys.core.resources.ResourceHandler;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;

public abstract class AbstractSimpleResourceHandlerProvider
extends AbstractResourceHandlerProvider
implements Configurable {
    protected Set<String> _supportedSuffixes;

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] suffixConf;
        this._supportedSuffixes = new HashSet<String>();
        for (Configuration suffix : suffixConf = configuration.getChild("suffixes").getChildren("suffix")) {
            this._supportedSuffixes.add(StringUtils.lowerCase((String)suffix.getValue()));
        }
    }

    @Override
    public ResourceHandler getResourceHandler(String source) throws Exception {
        String lcSource = StringUtils.lowerCase((String)source);
        if (this._supportedSuffixes.stream().anyMatch(suffix -> Strings.CS.endsWith((CharSequence)lcSource, (CharSequence)suffix))) {
            return this.setup(this.createResourceHandler(source));
        }
        return null;
    }

    protected abstract ResourceHandler createResourceHandler(String var1);
}

