/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.ametys.core.DevMode;
import org.ametys.core.resources.ExpiresResourceHandler;
import org.ametys.core.resources.ProxiedContextPathProvider;
import org.ametys.plugins.core.ui.resources.css.CSSFileHelper;
import org.ametys.plugins.core.ui.resources.css.JSASSResourceURIExtensionPoint;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.excalibur.source.Source;

public class CssResourceHandler
extends ExpiresResourceHandler {
    private ProxiedContextPathProvider _proxiedContextPathProvider;
    private JSASSResourceURIExtensionPoint _jsassResourceURIExtensionPoint;

    public CssResourceHandler() {
    }

    public CssResourceHandler(Source source) {
        super(source);
    }

    @Override
    public void service(ServiceManager manager) throws ServiceException {
        super.service(manager);
        this._proxiedContextPathProvider = (ProxiedContextPathProvider)manager.lookup(ProxiedContextPathProvider.ROLE);
        this._jsassResourceURIExtensionPoint = (JSASSResourceURIExtensionPoint)manager.lookup(JSASSResourceURIExtensionPoint.ROLE);
    }

    @Override
    public Serializable getKey() {
        return String.valueOf(super.getKey()) + "*" + this._proxiedContextPathProvider.getContextPath();
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        Request request = ObjectModelHelper.getRequest((Map)this._objectModel);
        if (DevMode.DEVMODE.SUPER_DEVELOPPMENT.equals((Object)DevMode.getDeveloperMode(request))) {
            super.generate(out);
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        super.generate(baos);
        String content = baos.toString(StandardCharsets.UTF_8.toString());
        try {
            String locationPath = this._jsassResourceURIExtensionPoint.resolve(this._requestedLocation);
            content = CSSFileHelper.replaceRelativeUri(content, locationPath, this._jsassResourceURIExtensionPoint, this._proxiedContextPathProvider.getContextPath(), this._proxiedContextPathProvider.getContextPath());
        }
        catch (URISyntaxException e) {
            throw new ProcessingException("Unable to replace relative URIs inside of css file '" + this._requestedLocation + "'", (Throwable)e);
        }
        out.write(content.getBytes(StandardCharsets.UTF_8));
    }
}

