/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.resources.SimpleResourceHandler;
import org.ametys.core.util.I18nUtils;
import org.ametys.core.util.language.LocaleHelper;
import org.ametys.runtime.i18n.I18nizableText;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.commons.io.IOUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;

public class I18nTextResourceHandler
extends SimpleResourceHandler
implements Contextualizable {
    private static final String __I18N_DEFAULT_CATALOGUE_ID = "default-catalogue-id";
    private static final char[] __I18N_BEGINNING_CHARS = new char[]{'{', '{', 'i', '1', '8', 'n'};
    private static final Pattern __LOCALE_PATTERN = Pattern.compile("^(.*resources/.*)\\.([^/.]+)\\.([^/.]+)$");
    protected Context _context;
    private I18nUtils _i18nUtils;
    private LocaleHelper _localeHelper;
    private boolean _isDeclarationValid;
    private String _locale;

    public void contextualize(Context context) throws ContextException {
        this._context = context;
    }

    @Override
    public void service(ServiceManager serviceManager) throws ServiceException {
        super.service(serviceManager);
        this._i18nUtils = (I18nUtils)((Object)serviceManager.lookup(I18nUtils.ROLE));
        this._localeHelper = (LocaleHelper)serviceManager.lookup(LocaleHelper.ROLE);
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters parameters, boolean readForDownload) throws ProcessingException, IOException {
        this._parameters = parameters;
        Source source = null;
        try {
            source = this._resolver.resolveURI(location);
        }
        catch (SourceException sourceException) {
            // empty catch block
        }
        if (source == null || !source.exists()) {
            this._resolver.release(source);
            Matcher matcher = __LOCALE_PATTERN.matcher(location);
            if (matcher.matches()) {
                String realSrc = matcher.group(1) + "." + matcher.group(3);
                this._locale = matcher.group(2);
                source = this._resolver.resolveURI(realSrc);
                if (!source.exists()) {
                    this._resolver.release(source);
                    throw new ResourceNotFoundException("Resource not found for URI : '" + location + "'.");
                }
            } else {
                throw new ResourceNotFoundException("Resource not found for URI : '" + location + "'.");
            }
        }
        this._source = source;
        return this._source;
    }

    protected String getLocale() {
        if (this._locale == null) {
            Map objectModel = ContextHelper.getObjectModel((Context)this._context);
            this._locale = this._localeHelper.findLocale(objectModel).getLanguage();
        }
        return this._locale;
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        if (!this._source.exists()) {
            throw new ResourceNotFoundException("Resource not found for URI : " + this._source.getURI());
        }
        BufferedWriter outWriter = null;
        try (InputStream is = this._source.getInputStream();){
            outWriter = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            int beginLength = __I18N_BEGINNING_CHARS.length;
            int endLength = 2;
            int minI18nDeclarationLength = beginLength + 1 + 1 + endLength;
            char[] srcChars = IOUtils.toCharArray((InputStream)is, (String)"UTF-8");
            int srcLength = srcChars.length;
            int skip = 0;
            int offset = 0;
            for (int i = 0; i < srcLength; i += skip) {
                skip = 1;
                char c = srcChars[i];
                if (c == '{' && i + minI18nDeclarationLength < srcLength) {
                    ++offset;
                    if (!this._testI18nDeclarationPrefix(srcChars, i)) continue;
                    char backspaceCandidate = srcChars[i + beginLength];
                    if (backspaceCandidate != ' ') {
                        this.getLogger().warn("Invalid i18n declaration in the file  '{}': '{{i18n' must be followed by a backspace.", (Object)this._source.getURI());
                        skip += beginLength;
                        offset += beginLength;
                        continue;
                    }
                    skip = this._analyzeI18nDeclaration(srcChars, i, outWriter, offset);
                    offset = this._isDeclarationValid ? 0 : offset + skip - 1;
                    continue;
                }
                if (c == '\\' && i + 1 + beginLength < srcLength && this._testI18nDeclarationPrefix(srcChars, i + 1)) {
                    outWriter.write(srcChars, i - offset, offset);
                    outWriter.write(123);
                    offset = 0;
                    ++skip;
                    continue;
                }
                ++offset;
            }
            if (offset == srcLength) {
                outWriter.write(srcChars, 0, srcChars.length);
            } else if (offset > 0) {
                outWriter.write(srcChars, srcLength - offset, offset);
            }
            outWriter.flush();
        }
    }

    private boolean _testI18nDeclarationPrefix(char[] srcChars, int start) {
        return srcChars[start] == '{' && srcChars[start + 1] == '{' && srcChars[start + 2] == 'i' && srcChars[start + 3] == '1' && srcChars[start + 4] == '8' && srcChars[start + 5] == 'n';
    }

    private int _analyzeI18nDeclaration(char[] srcChars, int candidateBeginIdx, BufferedWriter outWriter, int initialOffset) throws IOException {
        int j;
        this._isDeclarationValid = false;
        int beginLength = __I18N_BEGINNING_CHARS.length;
        int keyBeginningIndex = candidateBeginIdx + beginLength + 1;
        int srcLength = srcChars.length;
        boolean invalid = false;
        boolean valid = false;
        block5: for (j = keyBeginningIndex; j < srcLength && !invalid && !valid; ++j) {
            char c = srcChars[j];
            switch (c) {
                case '{': {
                    if (j + 1 == srcLength || srcChars[j + 1] != '{') continue block5;
                    this.getLogger().warn("Invalid i18n declaration in the file '{}': '{{' within an i18n declaration is forbidden.", (Object)this._source.getURI());
                    invalid = true;
                    continue block5;
                }
                case '}': {
                    if (j + 1 == srcLength || srcChars[j + 1] != '}') continue block5;
                    if (j == keyBeginningIndex) {
                        this.getLogger().warn("Invalid i18n declaration in the file  '{}': a key must be specified.", (Object)this._source.getURI());
                        invalid = true;
                        continue block5;
                    }
                    this._isDeclarationValid = true;
                    valid = true;
                    continue block5;
                }
                case '\n': {
                    this.getLogger().warn("Invalid i18n declaration in the file  '{}': '\\n' within an i18n declaration is forbidden. Make sure all i18n declarations are closed with the sequence '}}'.", (Object)this._source.getURI());
                    invalid = true;
                    continue block5;
                }
            }
        }
        if (!valid && !invalid) {
            this.getLogger().warn("Invalid i18n declaration in the file  '{}': Reached end of the file without finding the closing sequence of an i18n declaration.", (Object)this._source.getURI());
            return j - candidateBeginIdx;
        }
        if (valid) {
            this._translateKey(srcChars, outWriter, candidateBeginIdx, j, initialOffset);
        }
        return j - candidateBeginIdx + 1;
    }

    private void _translateKey(char[] srcChars, BufferedWriter outWriter, int candidateBeginIdx, int lastIdx, int initialOffset) throws IOException {
        String translation;
        int keyBeginningIndex = candidateBeginIdx + __I18N_BEGINNING_CHARS.length + 1;
        outWriter.write(srcChars, candidateBeginIdx - initialOffset + 1, initialOffset - 1);
        int keyLength = lastIdx - 1 - keyBeginningIndex;
        String key = String.valueOf(srcChars, keyBeginningIndex, keyLength);
        int indexOfSemiColon = key.indexOf(58);
        String catalogue = null;
        if (indexOfSemiColon != -1) {
            catalogue = key.substring(0, key.indexOf(58));
            key = key.substring(indexOfSemiColon + 1, key.length());
        }
        if (catalogue == null) {
            catalogue = this._parameters.getParameter(__I18N_DEFAULT_CATALOGUE_ID, null);
        }
        if ((translation = this._i18nUtils.translate(new I18nizableText(catalogue, key.trim()), this.getLocale())) == null) {
            this.getLogger().warn("Translation not found for key '{}' in catalogue '{}' with locale {}.", new Object[]{key, catalogue, this.getLocale()});
            char[] rawI18nDeclaration = new char[7 + keyLength + 2];
            System.arraycopy(srcChars, keyBeginningIndex - 7, rawI18nDeclaration, 0, 7 + keyLength + 2);
            translation = String.valueOf(rawI18nDeclaration);
        }
        outWriter.write(translation);
    }

    @Override
    public Serializable getKey() {
        return this._source.getURI() + "*" + this.getLocale();
    }
}

