/*
 * Decompiled with CFR 0.152.
 */
package org.ametys.core.resources;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ametys.core.resources.SimpleResourceHandler;
import org.ametys.core.util.ImageHelper;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;

public class ImageResourceHandler
extends SimpleResourceHandler {
    private static final Pattern _SIZE_PATTERN = Pattern.compile("^(.+)_(max|crop|)(\\d+)x(\\d+)(\\.[^./]+)?$");
    private static final Collection<String> __ALLOWED_OUTPUT_FORMATS = Set.of("png", "gif", "jpg", "jpeg");
    private static final Collection<String> __UNRESIZABLE_FORMATS = Set.of("svg");
    private int _height;
    private int _width;
    private int _maxHeight;
    private int _maxWidth;
    private int _cropHeight;
    private int _cropWidth;
    private boolean _download;

    public ImageResourceHandler() {
    }

    public ImageResourceHandler(SizedSource sizedSource) {
        super(sizedSource.source);
        this._toFields(sizedSource);
    }

    private void _toFields(SizedSource sizedSource) {
        this._source = sizedSource.source;
        this._height = sizedSource.height;
        this._width = sizedSource.width;
        this._maxHeight = sizedSource.maxHeight;
        this._maxWidth = sizedSource.maxWidth;
        this._cropHeight = sizedSource.cropHeight;
        this._cropWidth = sizedSource.cropWidth;
    }

    @Override
    public Source setup(String location, Map objectModel, Parameters par, boolean readForDownload) throws IOException, ProcessingException {
        SizedSource sizedSource;
        if (this._source == null && (sizedSource = ImageResourceHandler._resolveSource(location, this._resolver)) != null) {
            this._toFields(sizedSource);
        }
        if (this._source != null) {
            this._download = readForDownload;
            return this._source;
        }
        throw new ResourceNotFoundException("Resource not found for URI : " + location);
    }

    @Override
    public void generate(OutputStream out) throws IOException, ProcessingException {
        String fileExtension = StringUtils.substringAfterLast((String)this._source.getURI(), (String)".").toLowerCase();
        try (InputStream is = this._source.getInputStream();){
            if (this._processImage(fileExtension)) {
                String outputFormat = __ALLOWED_OUTPUT_FORMATS.contains(fileExtension) ? fileExtension : "png";
                ImageHelper.generateThumbnail(is, out, outputFormat, this._height, this._width, this._maxHeight, this._maxWidth, this._cropHeight, this._cropWidth);
            } else {
                IOUtils.copy((InputStream)is, (OutputStream)out);
            }
        }
    }

    private boolean _processImage(String fileExtension) {
        if (__UNRESIZABLE_FORMATS.contains(fileExtension)) {
            return false;
        }
        if (this._width > 0 || this._height > 0 || this._maxHeight > 0 || this._maxWidth > 0 || this._cropHeight > 0 || this._cropWidth > 0) {
            return true;
        }
        if (!this._download) {
            String mimeType = this._source.getMimeType();
            return mimeType != null && mimeType.startsWith("image/");
        }
        return false;
    }

    @Override
    public Serializable getKey() {
        return this._source.getURI() + "###" + this._width + "x" + this._height + "x" + this._maxWidth + "x" + this._maxHeight + "x" + this._cropWidth + "x" + this._cropHeight;
    }

    static SizedSource _resolveSource(String location, SourceResolver resolver) {
        try {
            Source source = resolver.resolveURI(location);
            if (source != null && source.exists()) {
                return new SizedSource(source, 0, 0, 0, 0, 0, 0);
            }
            resolver.release(source);
            Matcher sizeMatcher = _SIZE_PATTERN.matcher(location);
            if (sizeMatcher.matches()) {
                Object computedLocation = sizeMatcher.group(1);
                String suffix = sizeMatcher.group(5);
                if (suffix != null) {
                    computedLocation = (String)computedLocation + suffix;
                }
                if (!(source = resolver.resolveURI((String)computedLocation)).exists()) {
                    resolver.release(source);
                    return null;
                }
                String type = sizeMatcher.group(2);
                int pHeight = Integer.parseInt(sizeMatcher.group(3));
                int pWidth = Integer.parseInt(sizeMatcher.group(4));
                int height = "".equals(type) ? pHeight : 0;
                int width = "".equals(type) ? pWidth : 0;
                int maxHeight = "max".equals(type) ? pHeight : 0;
                int maxWidth = "max".equals(type) ? pWidth : 0;
                int cropHeight = "crop".equals(type) ? pHeight : 0;
                int cropWidth = "crop".equals(type) ? pWidth : 0;
                return new SizedSource(source, height, width, maxHeight, maxWidth, cropHeight, cropWidth);
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    record SizedSource(Source source, int height, int width, int maxHeight, int maxWidth, int cropHeight, int cropWidth) {
    }
}

